/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ReplicationConfiguration;
import software.amazon.awssdk.services.s3.transform.ReplicationRuleUnmarshaller;

public class ReplicationConfigurationUnmarshaller
implements Unmarshaller<ReplicationConfiguration, StaxUnmarshallerContext> {
    private static ReplicationConfigurationUnmarshaller INSTANCE;

    public ReplicationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReplicationConfiguration.Builder replicationConfiguration = ReplicationConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Role", targetDepth)) {
                    replicationConfiguration.role(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Rule", targetDepth)) continue;
                replicationConfiguration.rules(ReplicationRuleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReplicationConfiguration)replicationConfiguration.build();
    }

    public static ReplicationConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReplicationConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

