/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Grantee
implements ToCopyableBuilder<Builder, Grantee> {
    private final String displayName;
    private final String emailAddress;
    private final String id;
    private final String type;
    private final String uri;

    private Grantee(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.id = builder.id;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public String displayName() {
        return this.displayName;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String id() {
        return this.id;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String uri() {
        return this.uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee)obj;
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.uri(), other.uri());
    }

    public String toString() {
        return ToString.builder((String)"Grantee").add("DisplayName", (Object)this.displayName()).add("EmailAddress", (Object)this.emailAddress()).add("ID", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("URI", (Object)this.uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "EmailAddress": {
                return Optional.of(clazz.cast(this.emailAddress()));
            }
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "URI": {
                return Optional.of(clazz.cast(this.uri()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String emailAddress;
        private String id;
        private String type;
        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            this.displayName(model.displayName);
            this.emailAddress(model.emailAddress);
            this.id(model.id);
            this.type(model.type);
            this.uri(model.uri);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getURI() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setURI(String uri) {
            this.uri = uri;
        }

        public Grantee build() {
            return new Grantee(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Grantee> {
        public Builder displayName(String var1);

        public Builder emailAddress(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder uri(String var1);
    }
}

