/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.ExpirationStatus;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.LifecycleRuleFilter;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransitionListCopier;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.services.s3.model.TransitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleRule
implements ToCopyableBuilder<Builder, LifecycleRule> {
    private final LifecycleExpiration expiration;
    private final String id;
    private final String prefix;
    private final LifecycleRuleFilter filter;
    private final String status;
    private final List<Transition> transitions;
    private final List<NoncurrentVersionTransition> noncurrentVersionTransitions;
    private final NoncurrentVersionExpiration noncurrentVersionExpiration;
    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private LifecycleRule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.filter = builder.filter;
        this.status = builder.status;
        this.transitions = builder.transitions;
        this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    public LifecycleExpiration expiration() {
        return this.expiration;
    }

    public String id() {
        return this.id;
    }

    public String prefix() {
        return this.prefix;
    }

    public LifecycleRuleFilter filter() {
        return this.filter;
    }

    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<Transition> transitions() {
        return this.transitions;
    }

    public List<NoncurrentVersionTransition> noncurrentVersionTransitions() {
        return this.noncurrentVersionTransitions;
    }

    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return this.noncurrentVersionExpiration;
    }

    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return this.abortIncompleteMultipartUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.noncurrentVersionTransitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.noncurrentVersionExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortIncompleteMultipartUpload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRule)) {
            return false;
        }
        LifecycleRule other = (LifecycleRule)obj;
        return Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.transitions(), other.transitions()) && Objects.equals(this.noncurrentVersionTransitions(), other.noncurrentVersionTransitions()) && Objects.equals(this.noncurrentVersionExpiration(), other.noncurrentVersionExpiration()) && Objects.equals(this.abortIncompleteMultipartUpload(), other.abortIncompleteMultipartUpload());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleRule").add("Expiration", (Object)this.expiration()).add("ID", (Object)this.id()).add("Prefix", (Object)this.prefix()).add("Filter", (Object)this.filter()).add("Status", (Object)this.statusAsString()).add("Transitions", this.transitions()).add("NoncurrentVersionTransitions", this.noncurrentVersionTransitions()).add("NoncurrentVersionExpiration", (Object)this.noncurrentVersionExpiration()).add("AbortIncompleteMultipartUpload", (Object)this.abortIncompleteMultipartUpload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "Transitions": {
                return Optional.of(clazz.cast(this.transitions()));
            }
            case "NoncurrentVersionTransitions": {
                return Optional.of(clazz.cast(this.noncurrentVersionTransitions()));
            }
            case "NoncurrentVersionExpiration": {
                return Optional.of(clazz.cast(this.noncurrentVersionExpiration()));
            }
            case "AbortIncompleteMultipartUpload": {
                return Optional.of(clazz.cast(this.abortIncompleteMultipartUpload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private LifecycleExpiration expiration;
        private String id;
        private String prefix;
        private LifecycleRuleFilter filter;
        private String status;
        private List<Transition> transitions;
        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;
        private NoncurrentVersionExpiration noncurrentVersionExpiration;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRule model) {
            this.expiration(model.expiration);
            this.id(model.id);
            this.prefix(model.prefix);
            this.filter(model.filter);
            this.status(model.status);
            this.transitions(model.transitions);
            this.noncurrentVersionTransitions(model.noncurrentVersionTransitions);
            this.noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            this.abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return this.expiration != null ? this.expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final LifecycleRuleFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(LifecycleRuleFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(LifecycleRuleFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<Transition.Builder> getTransitions() {
            return this.transitions != null ? (Collection)this.transitions.stream().map(Transition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitions(Collection<Transition> transitions) {
            this.transitions = TransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Transition ... transitions) {
            this.transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Consumer<Transition.Builder> ... transitions) {
            this.transitions(Stream.of(transitions).map(c -> (Transition)((Transition.Builder)Transition.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitions(Collection<Transition.BuilderImpl> transitions) {
            this.transitions = TransitionListCopier.copyFromBuilder(transitions);
        }

        public final Collection<NoncurrentVersionTransition.Builder> getNoncurrentVersionTransitions() {
            return this.noncurrentVersionTransitions != null ? (Collection)this.noncurrentVersionTransitions.stream().map(NoncurrentVersionTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copy(noncurrentVersionTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(NoncurrentVersionTransition ... noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(Consumer<NoncurrentVersionTransition.Builder> ... noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions(Stream.of(noncurrentVersionTransitions).map(c -> (NoncurrentVersionTransition)((NoncurrentVersionTransition.Builder)NoncurrentVersionTransition.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNoncurrentVersionTransitions(Collection<NoncurrentVersionTransition.BuilderImpl> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copyFromBuilder(noncurrentVersionTransitions);
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration != null ? this.noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build() : null;
        }

        public LifecycleRule build() {
            return new LifecycleRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleRule> {
        public Builder expiration(LifecycleExpiration var1);

        default public Builder expiration(Consumer<LifecycleExpiration.Builder> expiration) {
            return this.expiration((LifecycleExpiration)((LifecycleExpiration.Builder)LifecycleExpiration.builder().apply(expiration)).build());
        }

        public Builder id(String var1);

        public Builder prefix(String var1);

        public Builder filter(LifecycleRuleFilter var1);

        default public Builder filter(Consumer<LifecycleRuleFilter.Builder> filter) {
            return this.filter((LifecycleRuleFilter)((LifecycleRuleFilter.Builder)LifecycleRuleFilter.builder().apply(filter)).build());
        }

        public Builder status(String var1);

        public Builder status(ExpirationStatus var1);

        public Builder transitions(Collection<Transition> var1);

        public Builder transitions(Transition ... var1);

        public Builder transitions(Consumer<Transition.Builder> ... var1);

        public Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> var1);

        public Builder noncurrentVersionTransitions(NoncurrentVersionTransition ... var1);

        public Builder noncurrentVersionTransitions(Consumer<NoncurrentVersionTransition.Builder> ... var1);

        public Builder noncurrentVersionExpiration(NoncurrentVersionExpiration var1);

        default public Builder noncurrentVersionExpiration(Consumer<NoncurrentVersionExpiration.Builder> noncurrentVersionExpiration) {
            return this.noncurrentVersionExpiration((NoncurrentVersionExpiration)((NoncurrentVersionExpiration.Builder)NoncurrentVersionExpiration.builder().apply(noncurrentVersionExpiration)).build());
        }

        public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload var1);

        default public Builder abortIncompleteMultipartUpload(Consumer<AbortIncompleteMultipartUpload.Builder> abortIncompleteMultipartUpload) {
            return this.abortIncompleteMultipartUpload((AbortIncompleteMultipartUpload)((AbortIncompleteMultipartUpload.Builder)AbortIncompleteMultipartUpload.builder().apply(abortIncompleteMultipartUpload)).build());
        }
    }
}

