/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutObjectAclRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutObjectAclRequest> {
    private final String acl;
    private final AccessControlPolicy accessControlPolicy;
    private final String bucket;
    private final String contentMD5;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWrite;
    private final String grantWriteACP;
    private final String key;
    private final String requestPayer;
    private final String versionId;

    private PutObjectAclRequest(BuilderImpl builder) {
        super(builder);
        this.acl = builder.acl;
        this.accessControlPolicy = builder.accessControlPolicy;
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
    }

    public ObjectCannedACL acl() {
        return ObjectCannedACL.fromValue(this.acl);
    }

    public String aclAsString() {
        return this.acl;
    }

    public AccessControlPolicy accessControlPolicy() {
        return this.accessControlPolicy;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWrite() {
        return this.grantWrite;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerAsString() {
        return this.requestPayer;
    }

    public String versionId() {
        return this.versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aclAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantFullControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantReadACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantWrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantWriteACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectAclRequest)) {
            return false;
        }
        PutObjectAclRequest other = (PutObjectAclRequest)((Object)obj);
        return Objects.equals(this.aclAsString(), other.aclAsString()) && Objects.equals(this.accessControlPolicy(), other.accessControlPolicy()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.contentMD5(), other.contentMD5()) && Objects.equals(this.grantFullControl(), other.grantFullControl()) && Objects.equals(this.grantRead(), other.grantRead()) && Objects.equals(this.grantReadACP(), other.grantReadACP()) && Objects.equals(this.grantWrite(), other.grantWrite()) && Objects.equals(this.grantWriteACP(), other.grantWriteACP()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.requestPayerAsString(), other.requestPayerAsString()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        return ToString.builder((String)"PutObjectAclRequest").add("ACL", (Object)this.aclAsString()).add("AccessControlPolicy", (Object)this.accessControlPolicy()).add("Bucket", (Object)this.bucket()).add("ContentMD5", (Object)this.contentMD5()).add("GrantFullControl", (Object)this.grantFullControl()).add("GrantRead", (Object)this.grantRead()).add("GrantReadACP", (Object)this.grantReadACP()).add("GrantWrite", (Object)this.grantWrite()).add("GrantWriteACP", (Object)this.grantWriteACP()).add("Key", (Object)this.key()).add("RequestPayer", (Object)this.requestPayerAsString()).add("VersionId", (Object)this.versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACL": {
                return Optional.of(clazz.cast(this.aclAsString()));
            }
            case "AccessControlPolicy": {
                return Optional.of(clazz.cast(this.accessControlPolicy()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
            case "GrantFullControl": {
                return Optional.of(clazz.cast(this.grantFullControl()));
            }
            case "GrantRead": {
                return Optional.of(clazz.cast(this.grantRead()));
            }
            case "GrantReadACP": {
                return Optional.of(clazz.cast(this.grantReadACP()));
            }
            case "GrantWrite": {
                return Optional.of(clazz.cast(this.grantWrite()));
            }
            case "GrantWriteACP": {
                return Optional.of(clazz.cast(this.grantWriteACP()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerAsString()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String acl;
        private AccessControlPolicy accessControlPolicy;
        private String bucket;
        private String contentMD5;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWrite;
        private String grantWriteACP;
        private String key;
        private String requestPayer;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectAclRequest model) {
            super(model);
            this.acl(model.acl);
            this.accessControlPolicy(model.accessControlPolicy);
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWrite(model.grantWrite);
            this.grantWriteACP(model.grantWriteACP);
            this.key(model.key);
            this.requestPayer(model.requestPayer);
            this.versionId(model.versionId);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final AccessControlPolicy.Builder getAccessControlPolicy() {
            return this.accessControlPolicy != null ? this.accessControlPolicy.toBuilder() : null;
        }

        @Override
        public final Builder accessControlPolicy(AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
            return this;
        }

        public final void setAccessControlPolicy(AccessControlPolicy.BuilderImpl accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy != null ? accessControlPolicy.build() : null;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return this.grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutObjectAclRequest build() {
            return new PutObjectAclRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutObjectAclRequest> {
        public Builder acl(String var1);

        public Builder acl(ObjectCannedACL var1);

        public Builder accessControlPolicy(AccessControlPolicy var1);

        default public Builder accessControlPolicy(Consumer<AccessControlPolicy.Builder> accessControlPolicy) {
            return this.accessControlPolicy((AccessControlPolicy)((AccessControlPolicy.Builder)AccessControlPolicy.builder().apply(accessControlPolicy)).build());
        }

        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWrite(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder versionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

