/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletedObject implements ToCopyableBuilder<DeletedObject.Builder, DeletedObject> {
    private final String key;

    private final String versionId;

    private final Boolean deleteMarker;

    private final String deleteMarkerVersionId;

    private DeletedObject(BuilderImpl builder) {
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.deleteMarker = builder.deleteMarker;
        this.deleteMarkerVersionId = builder.deleteMarkerVersionId;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * Returns the value of the VersionId property for this object.
     * 
     * @return The value of the VersionId property for this object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Returns the value of the DeleteMarker property for this object.
     * 
     * @return The value of the DeleteMarker property for this object.
     */
    public Boolean deleteMarker() {
        return deleteMarker;
    }

    /**
     * Returns the value of the DeleteMarkerVersionId property for this object.
     * 
     * @return The value of the DeleteMarkerVersionId property for this object.
     */
    public String deleteMarkerVersionId() {
        return deleteMarkerVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteMarker());
        hashCode = 31 * hashCode + Objects.hashCode(deleteMarkerVersionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletedObject)) {
            return false;
        }
        DeletedObject other = (DeletedObject) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(deleteMarker(), other.deleteMarker())
                && Objects.equals(deleteMarkerVersionId(), other.deleteMarkerVersionId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeletedObject").add("Key", key()).add("VersionId", versionId())
                .add("DeleteMarker", deleteMarker()).add("DeleteMarkerVersionId", deleteMarkerVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "DeleteMarker":
            return Optional.ofNullable(clazz.cast(deleteMarker()));
        case "DeleteMarkerVersionId":
            return Optional.ofNullable(clazz.cast(deleteMarkerVersionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeletedObject> {
        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the VersionId property for this object.
         *
         * @param versionId
         *        The new value for the VersionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Sets the value of the DeleteMarker property for this object.
         *
         * @param deleteMarker
         *        The new value for the DeleteMarker property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarker(Boolean deleteMarker);

        /**
         * Sets the value of the DeleteMarkerVersionId property for this object.
         *
         * @param deleteMarkerVersionId
         *        The new value for the DeleteMarkerVersionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkerVersionId(String deleteMarkerVersionId);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String versionId;

        private Boolean deleteMarker;

        private String deleteMarkerVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletedObject model) {
            key(model.key);
            versionId(model.versionId);
            deleteMarker(model.deleteMarker);
            deleteMarkerVersionId(model.deleteMarkerVersionId);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getDeleteMarker() {
            return deleteMarker;
        }

        @Override
        public final Builder deleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
            return this;
        }

        public final void setDeleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public final String getDeleteMarkerVersionId() {
            return deleteMarkerVersionId;
        }

        @Override
        public final Builder deleteMarkerVersionId(String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
            return this;
        }

        public final void setDeleteMarkerVersionId(String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
        }

        @Override
        public DeletedObject build() {
            return new DeletedObject(this);
        }
    }
}
