/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketRequestPaymentRequest extends S3Request implements
        ToCopyableBuilder<PutBucketRequestPaymentRequest.Builder, PutBucketRequestPaymentRequest> {
    private final String bucket;

    private final String contentMD5;

    private final RequestPaymentConfiguration requestPaymentConfiguration;

    private PutBucketRequestPaymentRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.requestPaymentConfiguration = builder.requestPaymentConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Returns the value of the RequestPaymentConfiguration property for this object.
     * 
     * @return The value of the RequestPaymentConfiguration property for this object.
     */
    public RequestPaymentConfiguration requestPaymentConfiguration() {
        return requestPaymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(requestPaymentConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketRequestPaymentRequest)) {
            return false;
        }
        PutBucketRequestPaymentRequest other = (PutBucketRequestPaymentRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(requestPaymentConfiguration(), other.requestPaymentConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketRequestPaymentRequest").add("Bucket", bucket()).add("ContentMD5", contentMD5())
                .add("RequestPaymentConfiguration", requestPaymentConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "RequestPaymentConfiguration":
            return Optional.ofNullable(clazz.cast(requestPaymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Sets the value of the RequestPaymentConfiguration property for this object.
         *
         * @param requestPaymentConfiguration
         *        The new value for the RequestPaymentConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration);

        /**
         * Sets the value of the RequestPaymentConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link RequestPaymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link RequestPaymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestPaymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #requestPaymentConfiguration(RequestPaymentConfiguration)}.
         * 
         * @param requestPaymentConfiguration
         *        a consumer that will call methods on {@link RequestPaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestPaymentConfiguration(RequestPaymentConfiguration)
         */
        default Builder requestPaymentConfiguration(Consumer<RequestPaymentConfiguration.Builder> requestPaymentConfiguration) {
            return requestPaymentConfiguration(RequestPaymentConfiguration.builder().applyMutation(requestPaymentConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private RequestPaymentConfiguration requestPaymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketRequestPaymentRequest model) {
            super(model);
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            requestPaymentConfiguration(model.requestPaymentConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final RequestPaymentConfiguration.Builder getRequestPaymentConfiguration() {
            return requestPaymentConfiguration != null ? requestPaymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration;
            return this;
        }

        public final void setRequestPaymentConfiguration(RequestPaymentConfiguration.BuilderImpl requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration != null ? requestPaymentConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketRequestPaymentRequest build() {
            return new PutBucketRequestPaymentRequest(this);
        }
    }
}
