/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectRequestMarshaller implements Marshaller<Request<GetObjectRequest>, GetObjectRequest> {

    public Request<GetObjectRequest> marshall(GetObjectRequest getObjectRequest) {

        if (getObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetObjectRequest> request = new DefaultRequest<GetObjectRequest>(getObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (getObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString(getObjectRequest.ifMatch()));
        }

        if (getObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringConversion.fromInstant(getObjectRequest.ifModifiedSince()));
        }

        if (getObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringConversion.fromString(getObjectRequest.ifNoneMatch()));
        }

        if (getObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringConversion.fromInstant(getObjectRequest.ifUnmodifiedSince()));
        }

        if (getObjectRequest.range() != null) {
            request.addHeader("Range", StringConversion.fromString(getObjectRequest.range()));
        }

        if (getObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringConversion.fromString(getObjectRequest.sseCustomerAlgorithm()));
        }

        if (getObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringConversion.fromString(getObjectRequest.sseCustomerKey()));
        }

        if (getObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringConversion.fromString(getObjectRequest.sseCustomerKeyMD5()));
        }

        if (getObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(getObjectRequest.requestPayerAsString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", getObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.GREEDY.marshall(uriResourcePath, "Key",
                getObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        if (getObjectRequest.responseCacheControl() != null) {
            request.addParameter("response-cache-control", StringConversion.fromString(getObjectRequest.responseCacheControl()));
        }

        if (getObjectRequest.responseContentDisposition() != null) {
            request.addParameter("response-content-disposition",
                    StringConversion.fromString(getObjectRequest.responseContentDisposition()));
        }

        if (getObjectRequest.responseContentEncoding() != null) {
            request.addParameter("response-content-encoding",
                    StringConversion.fromString(getObjectRequest.responseContentEncoding()));
        }

        if (getObjectRequest.responseContentLanguage() != null) {
            request.addParameter("response-content-language",
                    StringConversion.fromString(getObjectRequest.responseContentLanguage()));
        }

        if (getObjectRequest.responseContentType() != null) {
            request.addParameter("response-content-type", StringConversion.fromString(getObjectRequest.responseContentType()));
        }

        if (getObjectRequest.responseExpires() != null) {
            request.addParameter("response-expires", StringConversion.fromInstant(getObjectRequest.responseExpires()));
        }

        if (getObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString(getObjectRequest.versionId()));
        }

        if (getObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger(getObjectRequest.partNumber()));
        }

        return request;
    }

}