/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * ListPartsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListPartsRequestMarshaller implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {

    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {

        if (listPartsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<ListPartsRequest> request = new DefaultRequest<ListPartsRequest>(listPartsRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (listPartsRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(listPartsRequest.requestPayerAsString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", listPartsRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.GREEDY.marshall(uriResourcePath, "Key",
                listPartsRequest.key());
        request.setResourcePath(uriResourcePath);

        if (listPartsRequest.maxParts() != null) {
            request.addParameter("max-parts", StringConversion.fromInteger(listPartsRequest.maxParts()));
        }

        if (listPartsRequest.partNumberMarker() != null) {
            request.addParameter("part-number-marker", StringConversion.fromInteger(listPartsRequest.partNumberMarker()));
        }

        if (listPartsRequest.uploadId() != null) {
            request.addParameter("uploadId", StringConversion.fromString(listPartsRequest.uploadId()));
        }

        return request;
    }

}