/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketRequestPaymentRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketRequestPaymentRequestMarshaller implements
        Marshaller<Request<PutBucketRequestPaymentRequest>, PutBucketRequestPaymentRequest> {

    public Request<PutBucketRequestPaymentRequest> marshall(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) {

        if (putBucketRequestPaymentRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketRequestPaymentRequest> request = new DefaultRequest<PutBucketRequestPaymentRequest>(
                putBucketRequestPaymentRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketRequestPaymentRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketRequestPaymentRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?requestPayment";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketRequestPaymentRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            RequestPaymentConfiguration requestPaymentConfiguration = putBucketRequestPaymentRequest
                    .requestPaymentConfiguration();
            if (requestPaymentConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("RequestPaymentConfiguration");

                if (requestPaymentConfiguration.payerAsString() != null) {
                    xmlWriter.startElement("Payer").value(requestPaymentConfiguration.payerAsString()).endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}