/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * PutObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutObjectRequestMarshaller implements Marshaller<Request<PutObjectRequest>, PutObjectRequest> {

    public Request<PutObjectRequest> marshall(PutObjectRequest putObjectRequest) {

        if (putObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutObjectRequest> request = new DefaultRequest<PutObjectRequest>(putObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putObjectRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString(putObjectRequest.aclAsString()));
        }

        if (putObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringConversion.fromString(putObjectRequest.cacheControl()));
        }

        if (putObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringConversion.fromString(putObjectRequest.contentDisposition()));
        }

        if (putObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringConversion.fromString(putObjectRequest.contentEncoding()));
        }

        if (putObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringConversion.fromString(putObjectRequest.contentLanguage()));
        }

        if (putObjectRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringConversion.fromLong(putObjectRequest.contentLength()));
        }

        if (putObjectRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putObjectRequest.contentMD5()));
        }

        if (putObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringConversion.fromString(putObjectRequest.contentType()));
        }

        if (putObjectRequest.expires() != null) {
            request.addHeader("Expires", StringConversion.fromInstant(putObjectRequest.expires()));
        }

        if (putObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString(putObjectRequest.grantFullControl()));
        }

        if (putObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString(putObjectRequest.grantRead()));
        }

        if (putObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString(putObjectRequest.grantReadACP()));
        }

        if (putObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString(putObjectRequest.grantWriteACP()));
        }

        if (putObjectRequest.serverSideEncryptionAsString() != null) {
            request.addHeader("x-amz-server-side-encryption",
                    StringConversion.fromString(putObjectRequest.serverSideEncryptionAsString()));
        }

        if (putObjectRequest.storageClassAsString() != null) {
            request.addHeader("x-amz-storage-class", StringConversion.fromString(putObjectRequest.storageClassAsString()));
        }

        if (putObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location",
                    StringConversion.fromString(putObjectRequest.websiteRedirectLocation()));
        }

        if (putObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringConversion.fromString(putObjectRequest.sseCustomerAlgorithm()));
        }

        if (putObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringConversion.fromString(putObjectRequest.sseCustomerKey()));
        }

        if (putObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringConversion.fromString(putObjectRequest.sseCustomerKeyMD5()));
        }

        if (putObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id",
                    StringConversion.fromString(putObjectRequest.ssekmsKeyId()));
        }

        if (putObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString(putObjectRequest.requestPayerAsString()));
        }

        if (putObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringConversion.fromString(putObjectRequest.tagging()));
        }

        if (putObjectRequest.metadata() != null) {
            putObjectRequest.metadata().entrySet().forEach(e -> {
                if (e.getKey().startsWith("x-amz-meta-")) {
                    request.addHeader(e.getKey(), e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + e.getKey(), e.getValue());
                }
            });
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.GREEDY.marshall(uriResourcePath, "Key",
                putObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}