/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.auth.signer.S3SignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

@ReviewBeforeRelease(value="Check if there are other operations that should have chuncked encoding enabled by default.Do we even require this? By default chunked encoding is enabled. See AwsS3V4SignerParams classMaybe we need interceptor for payload signing as its disabled by default. See JAVA-2775")
public class EnableChunkedEncodingInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest sdkRequest = context.request();
        if (sdkRequest instanceof PutObjectRequest || sdkRequest instanceof UploadPartRequest) {
            executionAttributes.putAttribute(S3SignerExecutionAttribute.ENABLE_CHUNKED_ENCODING, (Object)Boolean.TRUE);
        }
        return sdkRequest;
    }
}

