/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.InventoryFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventorySchedule
implements ToCopyableBuilder<Builder, InventorySchedule> {
    private final String frequency;

    private InventorySchedule(BuilderImpl builder) {
        this.frequency = builder.frequency;
    }

    public InventoryFrequency frequency() {
        return InventoryFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventorySchedule)) {
            return false;
        }
        InventorySchedule other = (InventorySchedule)obj;
        return Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public String toString() {
        return ToString.builder((String)"InventorySchedule").add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(InventorySchedule model) {
            this.frequency(model.frequency);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(InventoryFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public InventorySchedule build() {
            return new InventorySchedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventorySchedule> {
        public Builder frequency(String var1);

        public Builder frequency(InventoryFrequency var1);
    }
}

