/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.MetricsConfiguration;
import software.amazon.awssdk.services.s3.model.MetricsConfigurationListCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBucketMetricsConfigurationsResponse
extends S3Response
implements ToCopyableBuilder<Builder, ListBucketMetricsConfigurationsResponse> {
    private final Boolean isTruncated;
    private final String continuationToken;
    private final String nextContinuationToken;
    private final List<MetricsConfiguration> metricsConfigurationList;

    private ListBucketMetricsConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.metricsConfigurationList = builder.metricsConfigurationList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public List<MetricsConfiguration> metricsConfigurationList() {
        return this.metricsConfigurationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfigurationList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketMetricsConfigurationsResponse)) {
            return false;
        }
        ListBucketMetricsConfigurationsResponse other = (ListBucketMetricsConfigurationsResponse)((Object)obj);
        return Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.nextContinuationToken(), other.nextContinuationToken()) && Objects.equals(this.metricsConfigurationList(), other.metricsConfigurationList());
    }

    public String toString() {
        return ToString.builder((String)"ListBucketMetricsConfigurationsResponse").add("IsTruncated", (Object)this.isTruncated()).add("ContinuationToken", (Object)this.continuationToken()).add("NextContinuationToken", (Object)this.nextContinuationToken()).add("MetricsConfigurationList", this.metricsConfigurationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "NextContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.nextContinuationToken()));
            }
            case "MetricsConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.metricsConfigurationList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String continuationToken;
        private String nextContinuationToken;
        private List<MetricsConfiguration> metricsConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketMetricsConfigurationsResponse model) {
            super(model);
            this.isTruncated(model.isTruncated);
            this.continuationToken(model.continuationToken);
            this.nextContinuationToken(model.nextContinuationToken);
            this.metricsConfigurationList(model.metricsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final Collection<MetricsConfiguration.Builder> getMetricsConfigurationList() {
            return this.metricsConfigurationList != null ? (Collection)this.metricsConfigurationList.stream().map(MetricsConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricsConfigurationList(Collection<MetricsConfiguration> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copy(metricsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsConfigurationList(MetricsConfiguration ... metricsConfigurationList) {
            this.metricsConfigurationList(Arrays.asList(metricsConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsConfigurationList(Consumer<MetricsConfiguration.Builder> ... metricsConfigurationList) {
            this.metricsConfigurationList(Stream.of(metricsConfigurationList).map(c -> (MetricsConfiguration)((MetricsConfiguration.Builder)MetricsConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricsConfigurationList(Collection<MetricsConfiguration.BuilderImpl> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copyFromBuilder(metricsConfigurationList);
        }

        @Override
        public ListBucketMetricsConfigurationsResponse build() {
            return new ListBucketMetricsConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, ListBucketMetricsConfigurationsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder continuationToken(String var1);

        public Builder nextContinuationToken(String var1);

        public Builder metricsConfigurationList(Collection<MetricsConfiguration> var1);

        public Builder metricsConfigurationList(MetricsConfiguration ... var1);

        public Builder metricsConfigurationList(Consumer<MetricsConfiguration.Builder> ... var1);
    }
}

