/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.MFADelete;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersioningConfiguration
implements ToCopyableBuilder<Builder, VersioningConfiguration> {
    private final String mfaDelete;
    private final String status;

    private VersioningConfiguration(BuilderImpl builder) {
        this.mfaDelete = builder.mfaDelete;
        this.status = builder.status;
    }

    public MFADelete mfaDelete() {
        return MFADelete.fromValue(this.mfaDelete);
    }

    public String mfaDeleteAsString() {
        return this.mfaDelete;
    }

    public BucketVersioningStatus status() {
        return BucketVersioningStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaDeleteAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersioningConfiguration)) {
            return false;
        }
        VersioningConfiguration other = (VersioningConfiguration)obj;
        return Objects.equals(this.mfaDeleteAsString(), other.mfaDeleteAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"VersioningConfiguration").add("MFADelete", (Object)this.mfaDeleteAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFADelete": {
                return Optional.ofNullable(clazz.cast(this.mfaDeleteAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String mfaDelete;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VersioningConfiguration model) {
            this.mfaDelete(model.mfaDelete);
            this.status(model.status);
        }

        public final String getMFADelete() {
            return this.mfaDelete;
        }

        @Override
        public final Builder mfaDelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
            return this;
        }

        @Override
        public final Builder mfaDelete(MFADelete mfaDelete) {
            this.mfaDelete(mfaDelete.toString());
            return this;
        }

        public final void setMFADelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BucketVersioningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public VersioningConfiguration build() {
            return new VersioningConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VersioningConfiguration> {
        public Builder mfaDelete(String var1);

        public Builder mfaDelete(MFADelete var1);

        public Builder status(String var1);

        public Builder status(BucketVersioningStatus var1);
    }
}

