/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CORSConfiguration;
import software.amazon.awssdk.services.s3.model.CORSRule;
import software.amazon.awssdk.services.s3.transform.CORSRuleUnmarshaller;

public class CORSConfigurationUnmarshaller
implements Unmarshaller<CORSConfiguration, StaxUnmarshallerContext> {
    private static final CORSConfigurationUnmarshaller INSTANCE = new CORSConfigurationUnmarshaller();

    public CORSConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CORSConfiguration.Builder corsConfiguration;
        block5: {
            corsConfiguration = CORSConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CORSRule> corsRules = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    corsConfiguration.corsRules(corsRules);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("CORSRule", targetDepth)) continue;
                    if (corsRules == null) {
                        corsRules = new ArrayList<CORSRule>();
                    }
                    corsRules.add(CORSRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            corsConfiguration.corsRules(corsRules);
        }
        return (CORSConfiguration)corsConfiguration.build();
    }

    public static CORSConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

