/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.model.InventoryDestination;
import software.amazon.awssdk.services.s3.model.InventoryFilter;
import software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination;
import software.amazon.awssdk.services.s3.model.InventorySchedule;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketInventoryConfigurationRequest>, PutBucketInventoryConfigurationRequest> {
    public Request<PutBucketInventoryConfigurationRequest> marshall(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {
        if (putBucketInventoryConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (putBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringConversion.fromString((String)putBucketInventoryConfigurationRequest.id()));
        }
        try {
            StringWriter stringWriter = null;
            InventoryConfiguration inventoryConfiguration = putBucketInventoryConfigurationRequest.inventoryConfiguration();
            if (inventoryConfiguration != null) {
                InventorySchedule schedule;
                List<String> inventoryConfigurationOptionalFieldsList;
                InventoryFilter filter;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("InventoryConfiguration");
                InventoryDestination destination = inventoryConfiguration.destination();
                if (destination != null) {
                    xmlWriter.startElement("Destination");
                    InventoryS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                    if (s3BucketDestination != null) {
                        xmlWriter.startElement("S3BucketDestination");
                        if (s3BucketDestination.accountId() != null) {
                            xmlWriter.startElement("AccountId").value(s3BucketDestination.accountId()).endElement();
                        }
                        if (s3BucketDestination.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                        }
                        if (s3BucketDestination.formatAsString() != null) {
                            xmlWriter.startElement("Format").value(s3BucketDestination.formatAsString()).endElement();
                        }
                        if (s3BucketDestination.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.isEnabled() != null) {
                    xmlWriter.startElement("IsEnabled").value((Object)inventoryConfiguration.isEnabled()).endElement();
                }
                if ((filter = inventoryConfiguration.filter()) != null) {
                    xmlWriter.startElement("Filter");
                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(inventoryConfiguration.id()).endElement();
                }
                if (inventoryConfiguration.includedObjectVersionsAsString() != null) {
                    xmlWriter.startElement("IncludedObjectVersions").value(inventoryConfiguration.includedObjectVersionsAsString()).endElement();
                }
                if (!(inventoryConfigurationOptionalFieldsList = inventoryConfiguration.optionalFieldsAsStrings()).isEmpty() || !(inventoryConfigurationOptionalFieldsList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("OptionalFields");
                    for (String inventoryConfigurationOptionalFieldsListValue : inventoryConfigurationOptionalFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(inventoryConfigurationOptionalFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((schedule = inventoryConfiguration.schedule()) != null) {
                    xmlWriter.startElement("Schedule");
                    if (schedule.frequencyAsString() != null) {
                        xmlWriter.startElement("Frequency").value(schedule.frequencyAsString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

