/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsFilter implements ToCopyableBuilder<AnalyticsFilter.Builder, AnalyticsFilter> {
    private final String prefix;

    private final Tag tag;

    private final AnalyticsAndOperator and;

    private AnalyticsFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * The prefix to use when evaluating an analytics filter.
     * 
     * @return The prefix to use when evaluating an analytics filter.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * The tag to use when evaluating an analytics filter.
     * 
     * @return The tag to use when evaluating an analytics filter.
     */
    public Tag tag() {
        return tag;
    }

    /**
     * A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator must
     * have at least two predicates.
     * 
     * @return A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator
     *         must have at least two predicates.
     */
    public AnalyticsAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(and());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsFilter)) {
            return false;
        }
        AnalyticsFilter other = (AnalyticsFilter) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(and(), other.and());
    }

    @Override
    public String toString() {
        return ToString.builder("AnalyticsFilter").add("Prefix", prefix()).add("Tag", tag()).add("And", and()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AnalyticsFilter> {
        /**
         * The prefix to use when evaluating an analytics filter.
         * 
         * @param prefix
         *        The prefix to use when evaluating an analytics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * The tag to use when evaluating an analytics filter.
         * 
         * @param tag
         *        The tag to use when evaluating an analytics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(Tag tag);

        /**
         * The tag to use when evaluating an analytics filter. This is a convenience that creates an instance of the
         * {@link Tag.Builder} avoiding the need to create one manually via {@link Tag#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tag.Builder#build()} is called immediately and its result is
         * passed to {@link #tag(Tag)}.
         * 
         * @param tag
         *        a consumer that will call methods on {@link Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(Tag)
         */
        default Builder tag(Consumer<Tag.Builder> tag) {
            return tag(Tag.builder().applyMutation(tag).build());
        }

        /**
         * A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator must
         * have at least two predicates.
         * 
         * @param and
         *        A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The
         *        operator must have at least two predicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(AnalyticsAndOperator and);

        /**
         * A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator must
         * have at least two predicates. This is a convenience that creates an instance of the
         * {@link AnalyticsAndOperator.Builder} avoiding the need to create one manually via
         * {@link AnalyticsAndOperator#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsAndOperator.Builder#build()} is called immediately and
         * its result is passed to {@link #and(AnalyticsAndOperator)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link AnalyticsAndOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(AnalyticsAndOperator)
         */
        default Builder and(Consumer<AnalyticsAndOperator.Builder> and) {
            return and(AnalyticsAndOperator.builder().applyMutation(and).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private Tag tag;

        private AnalyticsAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsFilter model) {
            prefix(model.prefix);
            tag(model.tag);
            and(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final AnalyticsAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        @Override
        public final Builder and(AnalyticsAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(AnalyticsAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public AnalyticsFilter build() {
            return new AnalyticsFilter(this);
        }
    }
}
