/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketAnalyticsConfigurationResponse extends S3Response implements
        ToCopyableBuilder<GetBucketAnalyticsConfigurationResponse.Builder, GetBucketAnalyticsConfigurationResponse> {
    private final AnalyticsConfiguration analyticsConfiguration;

    private GetBucketAnalyticsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.analyticsConfiguration = builder.analyticsConfiguration;
    }

    /**
     * The configuration and any analyses for the analytics filter.
     * 
     * @return The configuration and any analyses for the analytics filter.
     */
    public AnalyticsConfiguration analyticsConfiguration() {
        return analyticsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyticsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAnalyticsConfigurationResponse)) {
            return false;
        }
        GetBucketAnalyticsConfigurationResponse other = (GetBucketAnalyticsConfigurationResponse) obj;
        return Objects.equals(analyticsConfiguration(), other.analyticsConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketAnalyticsConfigurationResponse")
                .add("AnalyticsConfiguration", analyticsConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalyticsConfiguration":
            return Optional.ofNullable(clazz.cast(analyticsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, GetBucketAnalyticsConfigurationResponse> {
        /**
         * The configuration and any analyses for the analytics filter.
         * 
         * @param analyticsConfiguration
         *        The configuration and any analyses for the analytics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration);

        /**
         * The configuration and any analyses for the analytics filter. This is a convenience that creates an instance
         * of the {@link AnalyticsConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnalyticsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #analyticsConfiguration(AnalyticsConfiguration)}.
         * 
         * @param analyticsConfiguration
         *        a consumer that will call methods on {@link AnalyticsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyticsConfiguration(AnalyticsConfiguration)
         */
        default Builder analyticsConfiguration(Consumer<AnalyticsConfiguration.Builder> analyticsConfiguration) {
            return analyticsConfiguration(AnalyticsConfiguration.builder().applyMutation(analyticsConfiguration).build());
        }
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private AnalyticsConfiguration analyticsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAnalyticsConfigurationResponse model) {
            super(model);
            analyticsConfiguration(model.analyticsConfiguration);
        }

        public final AnalyticsConfiguration.Builder getAnalyticsConfiguration() {
            return analyticsConfiguration != null ? analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfiguration.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        @Override
        public GetBucketAnalyticsConfigurationResponse build() {
            return new GetBucketAnalyticsConfigurationResponse(this);
        }
    }
}
