/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketWebsiteResponse extends S3Response implements
        ToCopyableBuilder<GetBucketWebsiteResponse.Builder, GetBucketWebsiteResponse> {
    private final RedirectAllRequestsTo redirectAllRequestsTo;

    private final IndexDocument indexDocument;

    private final ErrorDocument errorDocument;

    private final List<RoutingRule> routingRules;

    private GetBucketWebsiteResponse(BuilderImpl builder) {
        super(builder);
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.indexDocument = builder.indexDocument;
        this.errorDocument = builder.errorDocument;
        this.routingRules = builder.routingRules;
    }

    /**
     * Returns the value of the RedirectAllRequestsTo property for this object.
     * 
     * @return The value of the RedirectAllRequestsTo property for this object.
     */
    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return redirectAllRequestsTo;
    }

    /**
     * Returns the value of the IndexDocument property for this object.
     * 
     * @return The value of the IndexDocument property for this object.
     */
    public IndexDocument indexDocument() {
        return indexDocument;
    }

    /**
     * Returns the value of the ErrorDocument property for this object.
     * 
     * @return The value of the ErrorDocument property for this object.
     */
    public ErrorDocument errorDocument() {
        return errorDocument;
    }

    /**
     * Returns the value of the RoutingRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the RoutingRules property for this object.
     */
    public List<RoutingRule> routingRules() {
        return routingRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redirectAllRequestsTo());
        hashCode = 31 * hashCode + Objects.hashCode(indexDocument());
        hashCode = 31 * hashCode + Objects.hashCode(errorDocument());
        hashCode = 31 * hashCode + Objects.hashCode(routingRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketWebsiteResponse)) {
            return false;
        }
        GetBucketWebsiteResponse other = (GetBucketWebsiteResponse) obj;
        return Objects.equals(redirectAllRequestsTo(), other.redirectAllRequestsTo())
                && Objects.equals(indexDocument(), other.indexDocument())
                && Objects.equals(errorDocument(), other.errorDocument()) && Objects.equals(routingRules(), other.routingRules());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketWebsiteResponse").add("RedirectAllRequestsTo", redirectAllRequestsTo())
                .add("IndexDocument", indexDocument()).add("ErrorDocument", errorDocument()).add("RoutingRules", routingRules())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedirectAllRequestsTo":
            return Optional.ofNullable(clazz.cast(redirectAllRequestsTo()));
        case "IndexDocument":
            return Optional.ofNullable(clazz.cast(indexDocument()));
        case "ErrorDocument":
            return Optional.ofNullable(clazz.cast(errorDocument()));
        case "RoutingRules":
            return Optional.ofNullable(clazz.cast(routingRules()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, GetBucketWebsiteResponse> {
        /**
         * Sets the value of the RedirectAllRequestsTo property for this object.
         *
         * @param redirectAllRequestsTo
         *        The new value for the RedirectAllRequestsTo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo);

        /**
         * Sets the value of the RedirectAllRequestsTo property for this object.
         *
         * This is a convenience that creates an instance of the {@link RedirectAllRequestsTo.Builder} avoiding the need
         * to create one manually via {@link RedirectAllRequestsTo#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedirectAllRequestsTo.Builder#build()} is called immediately and
         * its result is passed to {@link #redirectAllRequestsTo(RedirectAllRequestsTo)}.
         * 
         * @param redirectAllRequestsTo
         *        a consumer that will call methods on {@link RedirectAllRequestsTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redirectAllRequestsTo(RedirectAllRequestsTo)
         */
        default Builder redirectAllRequestsTo(Consumer<RedirectAllRequestsTo.Builder> redirectAllRequestsTo) {
            return redirectAllRequestsTo(RedirectAllRequestsTo.builder().applyMutation(redirectAllRequestsTo).build());
        }

        /**
         * Sets the value of the IndexDocument property for this object.
         *
         * @param indexDocument
         *        The new value for the IndexDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexDocument(IndexDocument indexDocument);

        /**
         * Sets the value of the IndexDocument property for this object.
         *
         * This is a convenience that creates an instance of the {@link IndexDocument.Builder} avoiding the need to
         * create one manually via {@link IndexDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link IndexDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #indexDocument(IndexDocument)}.
         * 
         * @param indexDocument
         *        a consumer that will call methods on {@link IndexDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexDocument(IndexDocument)
         */
        default Builder indexDocument(Consumer<IndexDocument.Builder> indexDocument) {
            return indexDocument(IndexDocument.builder().applyMutation(indexDocument).build());
        }

        /**
         * Sets the value of the ErrorDocument property for this object.
         *
         * @param errorDocument
         *        The new value for the ErrorDocument property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDocument(ErrorDocument errorDocument);

        /**
         * Sets the value of the ErrorDocument property for this object.
         *
         * This is a convenience that creates an instance of the {@link ErrorDocument.Builder} avoiding the need to
         * create one manually via {@link ErrorDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDocument(ErrorDocument)}.
         * 
         * @param errorDocument
         *        a consumer that will call methods on {@link ErrorDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDocument(ErrorDocument)
         */
        default Builder errorDocument(Consumer<ErrorDocument.Builder> errorDocument) {
            return errorDocument(ErrorDocument.builder().applyMutation(errorDocument).build());
        }

        /**
         * Sets the value of the RoutingRules property for this object.
         *
         * @param routingRules
         *        The new value for the RoutingRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(Collection<RoutingRule> routingRules);

        /**
         * Sets the value of the RoutingRules property for this object.
         *
         * @param routingRules
         *        The new value for the RoutingRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(RoutingRule... routingRules);

        /**
         * Sets the value of the RoutingRules property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<RoutingRule>.Builder} avoiding the need to
         * create one manually via {@link List<RoutingRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoutingRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #routingRules(List<RoutingRule>)}.
         * 
         * @param routingRules
         *        a consumer that will call methods on {@link List<RoutingRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingRules(List<RoutingRule>)
         */
        Builder routingRules(Consumer<RoutingRule.Builder>... routingRules);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private RedirectAllRequestsTo redirectAllRequestsTo;

        private IndexDocument indexDocument;

        private ErrorDocument errorDocument;

        private List<RoutingRule> routingRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketWebsiteResponse model) {
            super(model);
            redirectAllRequestsTo(model.redirectAllRequestsTo);
            indexDocument(model.indexDocument);
            errorDocument(model.errorDocument);
            routingRules(model.routingRules);
        }

        public final RedirectAllRequestsTo.Builder getRedirectAllRequestsTo() {
            return redirectAllRequestsTo != null ? redirectAllRequestsTo.toBuilder() : null;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        public final IndexDocument.Builder getIndexDocument() {
            return indexDocument != null ? indexDocument.toBuilder() : null;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument.BuilderImpl indexDocument) {
            this.indexDocument = indexDocument != null ? indexDocument.build() : null;
        }

        public final ErrorDocument.Builder getErrorDocument() {
            return errorDocument != null ? errorDocument.toBuilder() : null;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument.BuilderImpl errorDocument) {
            this.errorDocument = errorDocument != null ? errorDocument.build() : null;
        }

        public final Collection<RoutingRule.Builder> getRoutingRules() {
            return routingRules != null ? routingRules.stream().map(RoutingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule... routingRules) {
            routingRules(Arrays.asList(routingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(Consumer<RoutingRule.Builder>... routingRules) {
            routingRules(Stream.of(routingRules).map(c -> RoutingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule.BuilderImpl> routingRules) {
            this.routingRules = RoutingRulesCopier.copyFromBuilder(routingRules);
        }

        @Override
        public GetBucketWebsiteResponse build() {
            return new GetBucketWebsiteResponse(this);
        }
    }
}
