/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketTaggingRequest extends S3Request implements
        ToCopyableBuilder<PutBucketTaggingRequest.Builder, PutBucketTaggingRequest> {
    private final String bucket;

    private final String contentMD5;

    private final Tagging tagging;

    private PutBucketTaggingRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.tagging = builder.tagging;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Returns the value of the Tagging property for this object.
     * 
     * @return The value of the Tagging property for this object.
     */
    public Tagging tagging() {
        return tagging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(tagging());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketTaggingRequest)) {
            return false;
        }
        PutBucketTaggingRequest other = (PutBucketTaggingRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(tagging(), other.tagging());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketTaggingRequest").add("Bucket", bucket()).add("ContentMD5", contentMD5())
                .add("Tagging", tagging()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "Tagging":
            return Optional.ofNullable(clazz.cast(tagging()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketTaggingRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Sets the value of the Tagging property for this object.
         *
         * @param tagging
         *        The new value for the Tagging property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagging(Tagging tagging);

        /**
         * Sets the value of the Tagging property for this object.
         *
         * This is a convenience that creates an instance of the {@link Tagging.Builder} avoiding the need to create one
         * manually via {@link Tagging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tagging.Builder#build()} is called immediately and its result is
         * passed to {@link #tagging(Tagging)}.
         * 
         * @param tagging
         *        a consumer that will call methods on {@link Tagging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagging(Tagging)
         */
        default Builder tagging(Consumer<Tagging.Builder> tagging) {
            return tagging(Tagging.builder().applyMutation(tagging).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private Tagging tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketTaggingRequest model) {
            super(model);
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            tagging(model.tagging);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final Tagging.Builder getTagging() {
            return tagging != null ? tagging.toBuilder() : null;
        }

        @Override
        public final Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        public final void setTagging(Tagging.BuilderImpl tagging) {
            this.tagging = tagging != null ? tagging.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketTaggingRequest build() {
            return new PutBucketTaggingRequest(this);
        }
    }
}
