/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DeleteObjectResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteObjectResponseUnmarshaller implements Unmarshaller<DeleteObjectResponse, StaxUnmarshallerContext> {

    public DeleteObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DeleteObjectResponse.Builder deleteObjectResponse = DeleteObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-delete-marker");
            deleteObjectResponse.deleteMarker(BooleanUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            deleteObjectResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            deleteObjectResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        return deleteObjectResponse.build();
    }

    private static final DeleteObjectResponseUnmarshaller INSTANCE = new DeleteObjectResponseUnmarshaller();

    public static DeleteObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
