/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * LifecycleRule StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LifecycleRuleUnmarshaller implements Unmarshaller<LifecycleRule, StaxUnmarshallerContext> {

    public LifecycleRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleRule.Builder lifecycleRule = LifecycleRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Transition> transitions = null;
        java.util.List<NoncurrentVersionTransition> noncurrentVersionTransitions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                lifecycleRule.transitions(transitions);
                lifecycleRule.noncurrentVersionTransitions(noncurrentVersionTransitions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Expiration", targetDepth)) {
                    lifecycleRule.expiration(LifecycleExpirationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ID", targetDepth)) {
                    lifecycleRule.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Prefix", targetDepth)) {
                    lifecycleRule.prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Filter", targetDepth)) {
                    lifecycleRule.filter(LifecycleRuleFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    lifecycleRule.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Transition", targetDepth)) {
                    if (transitions == null) {
                        transitions = new ArrayList<>();
                    }
                    transitions.add(TransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NoncurrentVersionTransition", targetDepth)) {
                    if (noncurrentVersionTransitions == null) {
                        noncurrentVersionTransitions = new ArrayList<>();
                    }
                    noncurrentVersionTransitions.add(NoncurrentVersionTransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NoncurrentVersionExpiration", targetDepth)) {
                    lifecycleRule.noncurrentVersionExpiration(NoncurrentVersionExpirationUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("AbortIncompleteMultipartUpload", targetDepth)) {
                    lifecycleRule.abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    lifecycleRule.transitions(transitions);
                    lifecycleRule.noncurrentVersionTransitions(noncurrentVersionTransitions);
                    break;
                }
            }
        }
        return lifecycleRule.build();
    }

    private static final LifecycleRuleUnmarshaller INSTANCE = new LifecycleRuleUnmarshaller();

    public static LifecycleRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}
