/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketNotificationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketNotificationRequestMarshaller implements
        Marshaller<Request<PutBucketNotificationRequest>, PutBucketNotificationRequest> {

    public Request<PutBucketNotificationRequest> marshall(PutBucketNotificationRequest putBucketNotificationRequest) {

        if (putBucketNotificationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketNotificationRequest> request = new DefaultRequest<PutBucketNotificationRequest>(
                putBucketNotificationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketNotificationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketNotificationRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?notification";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketNotificationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            NotificationConfigurationDeprecated notificationConfiguration = putBucketNotificationRequest
                    .notificationConfiguration();
            if (notificationConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");

                TopicConfigurationDeprecated topicConfiguration = notificationConfiguration.topicConfiguration();
                if (topicConfiguration != null) {
                    xmlWriter.startElement("TopicConfiguration");

                    if (topicConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                    }

                    java.util.List<String> topicConfigurationDeprecatedEventsList = topicConfiguration.eventsAsStrings();
                    if (!topicConfigurationDeprecatedEventsList.isEmpty()
                            || !(topicConfigurationDeprecatedEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        for (String topicConfigurationDeprecatedEventsListValue : topicConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(topicConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (topicConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(topicConfiguration.eventAsString()).endElement();
                    }

                    if (topicConfiguration.topic() != null) {
                        xmlWriter.startElement("Topic").value(topicConfiguration.topic()).endElement();
                    }
                    xmlWriter.endElement();
                }

                QueueConfigurationDeprecated queueConfiguration = notificationConfiguration.queueConfiguration();
                if (queueConfiguration != null) {
                    xmlWriter.startElement("QueueConfiguration");

                    if (queueConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(queueConfiguration.id()).endElement();
                    }

                    if (queueConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(queueConfiguration.eventAsString()).endElement();
                    }

                    java.util.List<String> queueConfigurationDeprecatedEventsList = queueConfiguration.eventsAsStrings();
                    if (!queueConfigurationDeprecatedEventsList.isEmpty()
                            || !(queueConfigurationDeprecatedEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        for (String queueConfigurationDeprecatedEventsListValue : queueConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(queueConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (queueConfiguration.queue() != null) {
                        xmlWriter.startElement("Queue").value(queueConfiguration.queue()).endElement();
                    }
                    xmlWriter.endElement();
                }

                CloudFunctionConfiguration cloudFunctionConfiguration = notificationConfiguration.cloudFunctionConfiguration();
                if (cloudFunctionConfiguration != null) {
                    xmlWriter.startElement("CloudFunctionConfiguration");

                    if (cloudFunctionConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(cloudFunctionConfiguration.id()).endElement();
                    }

                    if (cloudFunctionConfiguration.eventAsString() != null) {
                        xmlWriter.startElement("Event").value(cloudFunctionConfiguration.eventAsString()).endElement();
                    }

                    java.util.List<String> cloudFunctionConfigurationEventsList = cloudFunctionConfiguration.eventsAsStrings();
                    if (!cloudFunctionConfigurationEventsList.isEmpty()
                            || !(cloudFunctionConfigurationEventsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                        for (String cloudFunctionConfigurationEventsListValue : cloudFunctionConfigurationEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(cloudFunctionConfigurationEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (cloudFunctionConfiguration.cloudFunction() != null) {
                        xmlWriter.startElement("CloudFunction").value(cloudFunctionConfiguration.cloudFunction()).endElement();
                    }

                    if (cloudFunctionConfiguration.invocationRole() != null) {
                        xmlWriter.startElement("InvocationRole").value(cloudFunctionConfiguration.invocationRole()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}