/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketReplicationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketReplicationRequestMarshaller implements
        Marshaller<Request<PutBucketReplicationRequest>, PutBucketReplicationRequest> {

    public Request<PutBucketReplicationRequest> marshall(PutBucketReplicationRequest putBucketReplicationRequest) {

        if (putBucketReplicationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketReplicationRequest> request = new DefaultRequest<PutBucketReplicationRequest>(
                putBucketReplicationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketReplicationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketReplicationRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?replication";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketReplicationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            ReplicationConfiguration replicationConfiguration = putBucketReplicationRequest.replicationConfiguration();
            if (replicationConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("ReplicationConfiguration");

                if (replicationConfiguration.role() != null) {
                    xmlWriter.startElement("Role").value(replicationConfiguration.role()).endElement();
                }

                java.util.List<ReplicationRule> replicationConfigurationRulesList = replicationConfiguration.rules();
                if (!replicationConfigurationRulesList.isEmpty()
                        || !(replicationConfigurationRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    for (ReplicationRule replicationConfigurationRulesListValue : replicationConfigurationRulesList) {
                        xmlWriter.startElement("Rule");

                        if (replicationConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(replicationConfigurationRulesListValue.id()).endElement();
                        }

                        if (replicationConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(replicationConfigurationRulesListValue.prefix()).endElement();
                        }

                        if (replicationConfigurationRulesListValue.statusAsString() != null) {
                            xmlWriter.startElement("Status").value(replicationConfigurationRulesListValue.statusAsString())
                                    .endElement();
                        }

                        Destination destination = replicationConfigurationRulesListValue.destination();
                        if (destination != null) {
                            xmlWriter.startElement("Destination");

                            if (destination.bucket() != null) {
                                xmlWriter.startElement("Bucket").value(destination.bucket()).endElement();
                            }

                            if (destination.storageClassAsString() != null) {
                                xmlWriter.startElement("StorageClass").value(destination.storageClassAsString()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}