/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * PutBucketWebsiteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketWebsiteRequestMarshaller implements Marshaller<Request<PutBucketWebsiteRequest>, PutBucketWebsiteRequest> {

    public Request<PutBucketWebsiteRequest> marshall(PutBucketWebsiteRequest putBucketWebsiteRequest) {

        if (putBucketWebsiteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutBucketWebsiteRequest> request = new DefaultRequest<PutBucketWebsiteRequest>(putBucketWebsiteRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketWebsiteRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString(putBucketWebsiteRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?website";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketWebsiteRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            WebsiteConfiguration websiteConfiguration = putBucketWebsiteRequest.websiteConfiguration();
            if (websiteConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("WebsiteConfiguration");

                ErrorDocument errorDocument = websiteConfiguration.errorDocument();
                if (errorDocument != null) {
                    xmlWriter.startElement("ErrorDocument");

                    if (errorDocument.key() != null) {
                        xmlWriter.startElement("Key").value(errorDocument.key()).endElement();
                    }
                    xmlWriter.endElement();
                }

                IndexDocument indexDocument = websiteConfiguration.indexDocument();
                if (indexDocument != null) {
                    xmlWriter.startElement("IndexDocument");

                    if (indexDocument.suffix() != null) {
                        xmlWriter.startElement("Suffix").value(indexDocument.suffix()).endElement();
                    }
                    xmlWriter.endElement();
                }

                RedirectAllRequestsTo redirectAllRequestsTo = websiteConfiguration.redirectAllRequestsTo();
                if (redirectAllRequestsTo != null) {
                    xmlWriter.startElement("RedirectAllRequestsTo");

                    if (redirectAllRequestsTo.hostName() != null) {
                        xmlWriter.startElement("HostName").value(redirectAllRequestsTo.hostName()).endElement();
                    }

                    if (redirectAllRequestsTo.protocolAsString() != null) {
                        xmlWriter.startElement("Protocol").value(redirectAllRequestsTo.protocolAsString()).endElement();
                    }
                    xmlWriter.endElement();
                }

                java.util.List<RoutingRule> websiteConfigurationRoutingRulesList = websiteConfiguration.routingRules();
                if (!websiteConfigurationRoutingRulesList.isEmpty()
                        || !(websiteConfigurationRoutingRulesList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    xmlWriter.startElement("RoutingRules");

                    for (RoutingRule websiteConfigurationRoutingRulesListValue : websiteConfigurationRoutingRulesList) {
                        xmlWriter.startElement("RoutingRule");

                        Condition condition = websiteConfigurationRoutingRulesListValue.condition();
                        if (condition != null) {
                            xmlWriter.startElement("Condition");

                            if (condition.httpErrorCodeReturnedEquals() != null) {
                                xmlWriter.startElement("HttpErrorCodeReturnedEquals")
                                        .value(condition.httpErrorCodeReturnedEquals()).endElement();
                            }

                            if (condition.keyPrefixEquals() != null) {
                                xmlWriter.startElement("KeyPrefixEquals").value(condition.keyPrefixEquals()).endElement();
                            }
                            xmlWriter.endElement();
                        }

                        Redirect redirect = websiteConfigurationRoutingRulesListValue.redirect();
                        if (redirect != null) {
                            xmlWriter.startElement("Redirect");

                            if (redirect.hostName() != null) {
                                xmlWriter.startElement("HostName").value(redirect.hostName()).endElement();
                            }

                            if (redirect.httpRedirectCode() != null) {
                                xmlWriter.startElement("HttpRedirectCode").value(redirect.httpRedirectCode()).endElement();
                            }

                            if (redirect.protocolAsString() != null) {
                                xmlWriter.startElement("Protocol").value(redirect.protocolAsString()).endElement();
                            }

                            if (redirect.replaceKeyPrefixWith() != null) {
                                xmlWriter.startElement("ReplaceKeyPrefixWith").value(redirect.replaceKeyPrefixWith())
                                        .endElement();
                            }

                            if (redirect.replaceKeyWith() != null) {
                                xmlWriter.startElement("ReplaceKeyWith").value(redirect.replaceKeyWith()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF_8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}