/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * TopicConfigurationDeprecated StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TopicConfigurationDeprecatedUnmarshaller implements
        Unmarshaller<TopicConfigurationDeprecated, StaxUnmarshallerContext> {

    public TopicConfigurationDeprecated unmarshall(StaxUnmarshallerContext context) throws Exception {
        TopicConfigurationDeprecated.Builder topicConfigurationDeprecated = TopicConfigurationDeprecated.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> events = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                topicConfigurationDeprecated.eventsWithStrings(events);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    topicConfigurationDeprecated.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    if (events == null) {
                        events = new ArrayList<>();
                    }
                    events.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    topicConfigurationDeprecated.event(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Topic", targetDepth)) {
                    topicConfigurationDeprecated.topic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    topicConfigurationDeprecated.eventsWithStrings(events);
                    break;
                }
            }
        }
        return topicConfigurationDeprecated.build();
    }

    private static final TopicConfigurationDeprecatedUnmarshaller INSTANCE = new TopicConfigurationDeprecatedUnmarshaller();

    public static TopicConfigurationDeprecatedUnmarshaller getInstance() {
        return INSTANCE;
    }
}
