/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFunctionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFunctionConfiguration.Builder, CloudFunctionConfiguration> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFunctionConfiguration::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFunctionConfiguration::eventAsString))
            .setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event")
                    .unmarshallLocationName("Event").build()).build();

    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CloudFunctionConfiguration::eventsAsStrings))
            .setter(setter(Builder::eventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events")
                    .unmarshallLocationName("Event").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<String> CLOUD_FUNCTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFunctionConfiguration::cloudFunction))
            .setter(setter(Builder::cloudFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFunction")
                    .unmarshallLocationName("CloudFunction").build()).build();

    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CloudFunctionConfiguration::invocationRole))
            .setter(setter(Builder::invocationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole")
                    .unmarshallLocationName("InvocationRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENT_FIELD,
            EVENTS_FIELD, CLOUD_FUNCTION_FIELD, INVOCATION_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String event;

    private final List<String> events;

    private final String cloudFunction;

    private final String invocationRole;

    private CloudFunctionConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.cloudFunction = builder.cloudFunction;
        this.invocationRole = builder.invocationRole;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see Event
     */
    public Event event() {
        return Event.fromValue(event);
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see Event
     */
    public String eventAsString() {
        return event;
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<Event> events() {
        return TypeConverter.convert(events, Event::fromValue);
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<String> eventsAsStrings() {
        return events;
    }

    /**
     * Returns the value of the CloudFunction property for this object.
     * 
     * @return The value of the CloudFunction property for this object.
     */
    public String cloudFunction() {
        return cloudFunction;
    }

    /**
     * Returns the value of the InvocationRole property for this object.
     * 
     * @return The value of the InvocationRole property for this object.
     */
    public String invocationRole() {
        return invocationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFunction());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFunctionConfiguration)) {
            return false;
        }
        CloudFunctionConfiguration other = (CloudFunctionConfiguration) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(eventsAsStrings(), other.eventsAsStrings())
                && Objects.equals(cloudFunction(), other.cloudFunction())
                && Objects.equals(invocationRole(), other.invocationRole());
    }

    @Override
    public String toString() {
        return ToString.builder("CloudFunctionConfiguration").add("Id", id()).add("Event", eventAsString())
                .add("Events", eventsAsStrings()).add("CloudFunction", cloudFunction()).add("InvocationRole", invocationRole())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "Events":
            return Optional.ofNullable(clazz.cast(eventsAsStrings()));
        case "CloudFunction":
            return Optional.ofNullable(clazz.cast(cloudFunction()));
        case "InvocationRole":
            return Optional.ofNullable(clazz.cast(invocationRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFunctionConfiguration, T> g) {
        return obj -> g.apply((CloudFunctionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFunctionConfiguration> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(Collection<String> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(String... events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * Sets the value of the CloudFunction property for this object.
         *
         * @param cloudFunction
         *        The new value for the CloudFunction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFunction(String cloudFunction);

        /**
         * Sets the value of the InvocationRole property for this object.
         *
         * @param invocationRole
         *        The new value for the InvocationRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRole(String invocationRole);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String event;

        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private String cloudFunction;

        private String invocationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFunctionConfiguration model) {
            id(model.id);
            event(model.event);
            eventsWithStrings(model.events);
            cloudFunction(model.cloudFunction);
            invocationRole(model.invocationRole);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String... events) {
            eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getCloudFunction() {
            return cloudFunction;
        }

        @Override
        public final Builder cloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
            return this;
        }

        public final void setCloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
        }

        public final String getInvocationRole() {
            return invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public CloudFunctionConfiguration build() {
            return new CloudFunctionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
