/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketCorsResponse extends S3Response implements
        ToCopyableBuilder<GetBucketCorsResponse.Builder, GetBucketCorsResponse> {
    private static final SdkField<List<CORSRule>> CORS_RULES_FIELD = SdkField
            .<List<CORSRule>> builder(MarshallingType.LIST)
            .getter(getter(GetBucketCorsResponse::corsRules))
            .setter(setter(Builder::corsRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CORSRules")
                    .unmarshallLocationName("CORSRule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CORSRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CORSRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORS_RULES_FIELD));

    private final List<CORSRule> corsRules;

    private GetBucketCorsResponse(BuilderImpl builder) {
        super(builder);
        this.corsRules = builder.corsRules;
    }

    /**
     * Returns the value of the CORSRules property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CORSRules property for this object.
     */
    public List<CORSRule> corsRules() {
        return corsRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(corsRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketCorsResponse)) {
            return false;
        }
        GetBucketCorsResponse other = (GetBucketCorsResponse) obj;
        return Objects.equals(corsRules(), other.corsRules());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketCorsResponse").add("CORSRules", corsRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CORSRules":
            return Optional.ofNullable(clazz.cast(corsRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketCorsResponse, T> g) {
        return obj -> g.apply((GetBucketCorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketCorsResponse> {
        /**
         * Sets the value of the CORSRules property for this object.
         *
         * @param corsRules
         *        The new value for the CORSRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsRules(Collection<CORSRule> corsRules);

        /**
         * Sets the value of the CORSRules property for this object.
         *
         * @param corsRules
         *        The new value for the CORSRules property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsRules(CORSRule... corsRules);

        /**
         * Sets the value of the CORSRules property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<CORSRule>.Builder} avoiding the need to
         * create one manually via {@link List<CORSRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CORSRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #corsRules(List<CORSRule>)}.
         * 
         * @param corsRules
         *        a consumer that will call methods on {@link List<CORSRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsRules(List<CORSRule>)
         */
        Builder corsRules(Consumer<CORSRule.Builder>... corsRules);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<CORSRule> corsRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketCorsResponse model) {
            super(model);
            corsRules(model.corsRules);
        }

        public final Collection<CORSRule.Builder> getCORSRules() {
            return corsRules != null ? corsRules.stream().map(CORSRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder corsRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsRules(CORSRule... corsRules) {
            corsRules(Arrays.asList(corsRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsRules(Consumer<CORSRule.Builder>... corsRules) {
            corsRules(Stream.of(corsRules).map(c -> CORSRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCORSRules(Collection<CORSRule.BuilderImpl> corsRules) {
            this.corsRules = CORSRulesCopier.copyFromBuilder(corsRules);
        }

        @Override
        public GetBucketCorsResponse build() {
            return new GetBucketCorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
