/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketNotificationResponse extends S3Response implements
        ToCopyableBuilder<GetBucketNotificationResponse.Builder, GetBucketNotificationResponse> {
    private static final SdkField<TopicConfigurationDeprecated> TOPIC_CONFIGURATION_FIELD = SdkField
            .<TopicConfigurationDeprecated> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketNotificationResponse::topicConfiguration))
            .setter(setter(Builder::topicConfiguration))
            .constructor(TopicConfigurationDeprecated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicConfiguration")
                    .unmarshallLocationName("TopicConfiguration").build()).build();

    private static final SdkField<QueueConfigurationDeprecated> QUEUE_CONFIGURATION_FIELD = SdkField
            .<QueueConfigurationDeprecated> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketNotificationResponse::queueConfiguration))
            .setter(setter(Builder::queueConfiguration))
            .constructor(QueueConfigurationDeprecated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfiguration")
                    .unmarshallLocationName("QueueConfiguration").build()).build();

    private static final SdkField<CloudFunctionConfiguration> CLOUD_FUNCTION_CONFIGURATION_FIELD = SdkField
            .<CloudFunctionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetBucketNotificationResponse::cloudFunctionConfiguration))
            .setter(setter(Builder::cloudFunctionConfiguration))
            .constructor(CloudFunctionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFunctionConfiguration")
                    .unmarshallLocationName("CloudFunctionConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_CONFIGURATION_FIELD,
            QUEUE_CONFIGURATION_FIELD, CLOUD_FUNCTION_CONFIGURATION_FIELD));

    private final TopicConfigurationDeprecated topicConfiguration;

    private final QueueConfigurationDeprecated queueConfiguration;

    private final CloudFunctionConfiguration cloudFunctionConfiguration;

    private GetBucketNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.topicConfiguration = builder.topicConfiguration;
        this.queueConfiguration = builder.queueConfiguration;
        this.cloudFunctionConfiguration = builder.cloudFunctionConfiguration;
    }

    /**
     * Returns the value of the TopicConfiguration property for this object.
     * 
     * @return The value of the TopicConfiguration property for this object.
     */
    public TopicConfigurationDeprecated topicConfiguration() {
        return topicConfiguration;
    }

    /**
     * Returns the value of the QueueConfiguration property for this object.
     * 
     * @return The value of the QueueConfiguration property for this object.
     */
    public QueueConfigurationDeprecated queueConfiguration() {
        return queueConfiguration;
    }

    /**
     * Returns the value of the CloudFunctionConfiguration property for this object.
     * 
     * @return The value of the CloudFunctionConfiguration property for this object.
     */
    public CloudFunctionConfiguration cloudFunctionConfiguration() {
        return cloudFunctionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(queueConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFunctionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketNotificationResponse)) {
            return false;
        }
        GetBucketNotificationResponse other = (GetBucketNotificationResponse) obj;
        return Objects.equals(topicConfiguration(), other.topicConfiguration())
                && Objects.equals(queueConfiguration(), other.queueConfiguration())
                && Objects.equals(cloudFunctionConfiguration(), other.cloudFunctionConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketNotificationResponse").add("TopicConfiguration", topicConfiguration())
                .add("QueueConfiguration", queueConfiguration()).add("CloudFunctionConfiguration", cloudFunctionConfiguration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicConfiguration":
            return Optional.ofNullable(clazz.cast(topicConfiguration()));
        case "QueueConfiguration":
            return Optional.ofNullable(clazz.cast(queueConfiguration()));
        case "CloudFunctionConfiguration":
            return Optional.ofNullable(clazz.cast(cloudFunctionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketNotificationResponse, T> g) {
        return obj -> g.apply((GetBucketNotificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketNotificationResponse> {
        /**
         * Sets the value of the TopicConfiguration property for this object.
         *
         * @param topicConfiguration
         *        The new value for the TopicConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration);

        /**
         * Sets the value of the TopicConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link TopicConfigurationDeprecated.Builder} avoiding
         * the need to create one manually via {@link TopicConfigurationDeprecated#builder()}.
         *
         * When the {@link Consumer} completes, {@link TopicConfigurationDeprecated.Builder#build()} is called
         * immediately and its result is passed to {@link #topicConfiguration(TopicConfigurationDeprecated)}.
         * 
         * @param topicConfiguration
         *        a consumer that will call methods on {@link TopicConfigurationDeprecated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicConfiguration(TopicConfigurationDeprecated)
         */
        default Builder topicConfiguration(Consumer<TopicConfigurationDeprecated.Builder> topicConfiguration) {
            return topicConfiguration(TopicConfigurationDeprecated.builder().applyMutation(topicConfiguration).build());
        }

        /**
         * Sets the value of the QueueConfiguration property for this object.
         *
         * @param queueConfiguration
         *        The new value for the QueueConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration);

        /**
         * Sets the value of the QueueConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link QueueConfigurationDeprecated.Builder} avoiding
         * the need to create one manually via {@link QueueConfigurationDeprecated#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueueConfigurationDeprecated.Builder#build()} is called
         * immediately and its result is passed to {@link #queueConfiguration(QueueConfigurationDeprecated)}.
         * 
         * @param queueConfiguration
         *        a consumer that will call methods on {@link QueueConfigurationDeprecated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueConfiguration(QueueConfigurationDeprecated)
         */
        default Builder queueConfiguration(Consumer<QueueConfigurationDeprecated.Builder> queueConfiguration) {
            return queueConfiguration(QueueConfigurationDeprecated.builder().applyMutation(queueConfiguration).build());
        }

        /**
         * Sets the value of the CloudFunctionConfiguration property for this object.
         *
         * @param cloudFunctionConfiguration
         *        The new value for the CloudFunctionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration);

        /**
         * Sets the value of the CloudFunctionConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link CloudFunctionConfiguration.Builder} avoiding the
         * need to create one manually via {@link CloudFunctionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFunctionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFunctionConfiguration(CloudFunctionConfiguration)}.
         * 
         * @param cloudFunctionConfiguration
         *        a consumer that will call methods on {@link CloudFunctionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFunctionConfiguration(CloudFunctionConfiguration)
         */
        default Builder cloudFunctionConfiguration(Consumer<CloudFunctionConfiguration.Builder> cloudFunctionConfiguration) {
            return cloudFunctionConfiguration(CloudFunctionConfiguration.builder().applyMutation(cloudFunctionConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private TopicConfigurationDeprecated topicConfiguration;

        private QueueConfigurationDeprecated queueConfiguration;

        private CloudFunctionConfiguration cloudFunctionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketNotificationResponse model) {
            super(model);
            topicConfiguration(model.topicConfiguration);
            queueConfiguration(model.queueConfiguration);
            cloudFunctionConfiguration(model.cloudFunctionConfiguration);
        }

        public final TopicConfigurationDeprecated.Builder getTopicConfiguration() {
            return topicConfiguration != null ? topicConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
            return this;
        }

        public final void setTopicConfiguration(TopicConfigurationDeprecated.BuilderImpl topicConfiguration) {
            this.topicConfiguration = topicConfiguration != null ? topicConfiguration.build() : null;
        }

        public final QueueConfigurationDeprecated.Builder getQueueConfiguration() {
            return queueConfiguration != null ? queueConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
            return this;
        }

        public final void setQueueConfiguration(QueueConfigurationDeprecated.BuilderImpl queueConfiguration) {
            this.queueConfiguration = queueConfiguration != null ? queueConfiguration.build() : null;
        }

        public final CloudFunctionConfiguration.Builder getCloudFunctionConfiguration() {
            return cloudFunctionConfiguration != null ? cloudFunctionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
            return this;
        }

        public final void setCloudFunctionConfiguration(CloudFunctionConfiguration.BuilderImpl cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration != null ? cloudFunctionConfiguration.build() : null;
        }

        @Override
        public GetBucketNotificationResponse build() {
            return new GetBucketNotificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
