/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObjectVersionsResponse extends S3Response implements
        ToCopyableBuilder<ListObjectVersionsResponse.Builder, ListObjectVersionsResponse> {
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListObjectVersionsResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> KEY_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::keyMarker))
            .setter(setter(Builder::keyMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMarker")
                    .unmarshallLocationName("KeyMarker").build()).build();

    private static final SdkField<String> VERSION_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::versionIdMarker))
            .setter(setter(Builder::versionIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionIdMarker")
                    .unmarshallLocationName("VersionIdMarker").build()).build();

    private static final SdkField<String> NEXT_KEY_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::nextKeyMarker))
            .setter(setter(Builder::nextKeyMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextKeyMarker")
                    .unmarshallLocationName("NextKeyMarker").build()).build();

    private static final SdkField<String> NEXT_VERSION_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::nextVersionIdMarker))
            .setter(setter(Builder::nextVersionIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextVersionIdMarker")
                    .unmarshallLocationName("NextVersionIdMarker").build()).build();

    private static final SdkField<List<ObjectVersion>> VERSIONS_FIELD = SdkField
            .<List<ObjectVersion>> builder(MarshallingType.LIST)
            .getter(getter(ListObjectVersionsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions")
                    .unmarshallLocationName("Version").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<List<DeleteMarkerEntry>> DELETE_MARKERS_FIELD = SdkField
            .<List<DeleteMarkerEntry>> builder(MarshallingType.LIST)
            .getter(getter(ListObjectVersionsResponse::deleteMarkers))
            .setter(setter(Builder::deleteMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteMarkers")
                    .unmarshallLocationName("DeleteMarker").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteMarkerEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteMarkerEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<String> DELIMITER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::delimiter))
            .setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter")
                    .unmarshallLocationName("Delimiter").build()).build();

    private static final SdkField<Integer> MAX_KEYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListObjectVersionsResponse::maxKeys))
            .setter(setter(Builder::maxKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxKeys")
                    .unmarshallLocationName("MaxKeys").build()).build();

    private static final SdkField<List<CommonPrefix>> COMMON_PREFIXES_FIELD = SdkField
            .<List<CommonPrefix>> builder(MarshallingType.LIST)
            .getter(getter(ListObjectVersionsResponse::commonPrefixes))
            .setter(setter(Builder::commonPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonPrefixes")
                    .unmarshallLocationName("CommonPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommonPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommonPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListObjectVersionsResponse::encodingTypeAsString))
            .setter(setter(Builder::encodingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType")
                    .unmarshallLocationName("EncodingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_TRUNCATED_FIELD,
            KEY_MARKER_FIELD, VERSION_ID_MARKER_FIELD, NEXT_KEY_MARKER_FIELD, NEXT_VERSION_ID_MARKER_FIELD, VERSIONS_FIELD,
            DELETE_MARKERS_FIELD, NAME_FIELD, PREFIX_FIELD, DELIMITER_FIELD, MAX_KEYS_FIELD, COMMON_PREFIXES_FIELD,
            ENCODING_TYPE_FIELD));

    private final Boolean isTruncated;

    private final String keyMarker;

    private final String versionIdMarker;

    private final String nextKeyMarker;

    private final String nextVersionIdMarker;

    private final List<ObjectVersion> versions;

    private final List<DeleteMarkerEntry> deleteMarkers;

    private final String name;

    private final String prefix;

    private final String delimiter;

    private final Integer maxKeys;

    private final List<CommonPrefix> commonPrefixes;

    private final String encodingType;

    private ListObjectVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.isTruncated = builder.isTruncated;
        this.keyMarker = builder.keyMarker;
        this.versionIdMarker = builder.versionIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.nextVersionIdMarker = builder.nextVersionIdMarker;
        this.versions = builder.versions;
        this.deleteMarkers = builder.deleteMarkers;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    /**
     * <p>
     * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search criteria. If
     * your results were truncated, you can make a follow-up paginated request using the NextKeyMarker and
     * NextVersionIdMarker response parameters as a starting place in another request to return the rest of the results.
     * </p>
     * 
     * @return A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
     *         criteria. If your results were truncated, you can make a follow-up paginated request using the
     *         NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to
     *         return the rest of the results.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * Marks the last Key returned in a truncated response.
     * </p>
     * 
     * @return Marks the last Key returned in a truncated response.
     */
    public String keyMarker() {
        return keyMarker;
    }

    /**
     * Returns the value of the VersionIdMarker property for this object.
     * 
     * @return The value of the VersionIdMarker property for this object.
     */
    public String versionIdMarker() {
        return versionIdMarker;
    }

    /**
     * <p>
     * Use this value for the key marker request parameter in a subsequent request.
     * </p>
     * 
     * @return Use this value for the key marker request parameter in a subsequent request.
     */
    public String nextKeyMarker() {
        return nextKeyMarker;
    }

    /**
     * <p>
     * Use this value for the next version id marker parameter in a subsequent request.
     * </p>
     * 
     * @return Use this value for the next version id marker parameter in a subsequent request.
     */
    public String nextVersionIdMarker() {
        return nextVersionIdMarker;
    }

    /**
     * Returns the value of the Versions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Versions property for this object.
     */
    public List<ObjectVersion> versions() {
        return versions;
    }

    /**
     * Returns the value of the DeleteMarkers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the DeleteMarkers property for this object.
     */
    public List<DeleteMarkerEntry> deleteMarkers() {
        return deleteMarkers;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the Prefix property for this object.
     * 
     * @return The value of the Prefix property for this object.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Delimiter property for this object.
     * 
     * @return The value of the Delimiter property for this object.
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     * Returns the value of the MaxKeys property for this object.
     * 
     * @return The value of the MaxKeys property for this object.
     */
    public Integer maxKeys() {
        return maxKeys;
    }

    /**
     * Returns the value of the CommonPrefixes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the CommonPrefixes property for this object.
     */
    public List<CommonPrefix> commonPrefixes() {
        return commonPrefixes;
    }

    /**
     * <p>
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public EncodingType encodingType() {
        return EncodingType.fromValue(encodingType);
    }

    /**
     * <p>
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public String encodingTypeAsString() {
        return encodingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(keyMarker());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(nextKeyMarker());
        hashCode = 31 * hashCode + Objects.hashCode(nextVersionIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        hashCode = 31 * hashCode + Objects.hashCode(deleteMarkers());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(maxKeys());
        hashCode = 31 * hashCode + Objects.hashCode(commonPrefixes());
        hashCode = 31 * hashCode + Objects.hashCode(encodingTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectVersionsResponse)) {
            return false;
        }
        ListObjectVersionsResponse other = (ListObjectVersionsResponse) obj;
        return Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(keyMarker(), other.keyMarker())
                && Objects.equals(versionIdMarker(), other.versionIdMarker())
                && Objects.equals(nextKeyMarker(), other.nextKeyMarker())
                && Objects.equals(nextVersionIdMarker(), other.nextVersionIdMarker())
                && Objects.equals(versions(), other.versions()) && Objects.equals(deleteMarkers(), other.deleteMarkers())
                && Objects.equals(name(), other.name()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(delimiter(), other.delimiter()) && Objects.equals(maxKeys(), other.maxKeys())
                && Objects.equals(commonPrefixes(), other.commonPrefixes())
                && Objects.equals(encodingTypeAsString(), other.encodingTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ListObjectVersionsResponse").add("IsTruncated", isTruncated()).add("KeyMarker", keyMarker())
                .add("VersionIdMarker", versionIdMarker()).add("NextKeyMarker", nextKeyMarker())
                .add("NextVersionIdMarker", nextVersionIdMarker()).add("Versions", versions())
                .add("DeleteMarkers", deleteMarkers()).add("Name", name()).add("Prefix", prefix()).add("Delimiter", delimiter())
                .add("MaxKeys", maxKeys()).add("CommonPrefixes", commonPrefixes()).add("EncodingType", encodingTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "KeyMarker":
            return Optional.ofNullable(clazz.cast(keyMarker()));
        case "VersionIdMarker":
            return Optional.ofNullable(clazz.cast(versionIdMarker()));
        case "NextKeyMarker":
            return Optional.ofNullable(clazz.cast(nextKeyMarker()));
        case "NextVersionIdMarker":
            return Optional.ofNullable(clazz.cast(nextVersionIdMarker()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "DeleteMarkers":
            return Optional.ofNullable(clazz.cast(deleteMarkers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "MaxKeys":
            return Optional.ofNullable(clazz.cast(maxKeys()));
        case "CommonPrefixes":
            return Optional.ofNullable(clazz.cast(commonPrefixes()));
        case "EncodingType":
            return Optional.ofNullable(clazz.cast(encodingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectVersionsResponse, T> g) {
        return obj -> g.apply((ListObjectVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, ListObjectVersionsResponse> {
        /**
         * <p>
         * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         * criteria. If your results were truncated, you can make a follow-up paginated request using the NextKeyMarker
         * and NextVersionIdMarker response parameters as a starting place in another request to return the rest of the
         * results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         *        criteria. If your results were truncated, you can make a follow-up paginated request using the
         *        NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to
         *        return the rest of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * Marks the last Key returned in a truncated response.
         * </p>
         * 
         * @param keyMarker
         *        Marks the last Key returned in a truncated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMarker(String keyMarker);

        /**
         * Sets the value of the VersionIdMarker property for this object.
         *
         * @param versionIdMarker
         *        The new value for the VersionIdMarker property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdMarker(String versionIdMarker);

        /**
         * <p>
         * Use this value for the key marker request parameter in a subsequent request.
         * </p>
         * 
         * @param nextKeyMarker
         *        Use this value for the key marker request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextKeyMarker(String nextKeyMarker);

        /**
         * <p>
         * Use this value for the next version id marker parameter in a subsequent request.
         * </p>
         * 
         * @param nextVersionIdMarker
         *        Use this value for the next version id marker parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextVersionIdMarker(String nextVersionIdMarker);

        /**
         * Sets the value of the Versions property for this object.
         *
         * @param versions
         *        The new value for the Versions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<ObjectVersion> versions);

        /**
         * Sets the value of the Versions property for this object.
         *
         * @param versions
         *        The new value for the Versions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(ObjectVersion... versions);

        /**
         * Sets the value of the Versions property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<ObjectVersion>.Builder} avoiding the need
         * to create one manually via {@link List<ObjectVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #versions(List<ObjectVersion>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<ObjectVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<ObjectVersion>)
         */
        Builder versions(Consumer<ObjectVersion.Builder>... versions);

        /**
         * Sets the value of the DeleteMarkers property for this object.
         *
         * @param deleteMarkers
         *        The new value for the DeleteMarkers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers);

        /**
         * Sets the value of the DeleteMarkers property for this object.
         *
         * @param deleteMarkers
         *        The new value for the DeleteMarkers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarkers(DeleteMarkerEntry... deleteMarkers);

        /**
         * Sets the value of the DeleteMarkers property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<DeleteMarkerEntry>.Builder} avoiding the
         * need to create one manually via {@link List<DeleteMarkerEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeleteMarkerEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #deleteMarkers(List<DeleteMarkerEntry>)}.
         * 
         * @param deleteMarkers
         *        a consumer that will call methods on {@link List<DeleteMarkerEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteMarkers(List<DeleteMarkerEntry>)
         */
        Builder deleteMarkers(Consumer<DeleteMarkerEntry.Builder>... deleteMarkers);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Prefix property for this object.
         *
         * @param prefix
         *        The new value for the Prefix property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Delimiter property for this object.
         *
         * @param delimiter
         *        The new value for the Delimiter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * Sets the value of the MaxKeys property for this object.
         *
         * @param maxKeys
         *        The new value for the MaxKeys property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKeys(Integer maxKeys);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * @param commonPrefixes
         *        The new value for the CommonPrefixes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(CommonPrefix... commonPrefixes);

        /**
         * Sets the value of the CommonPrefixes property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<CommonPrefix>.Builder} avoiding the need to
         * create one manually via {@link List<CommonPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CommonPrefix>.Builder#build()} is called immediately and its
         * result is passed to {@link #commonPrefixes(List<CommonPrefix>)}.
         * 
         * @param commonPrefixes
         *        a consumer that will call methods on {@link List<CommonPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commonPrefixes(List<CommonPrefix>)
         */
        Builder commonPrefixes(Consumer<CommonPrefix.Builder>... commonPrefixes);

        /**
         * <p>
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * </p>
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * <p>
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * </p>
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @see EncodingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private Boolean isTruncated;

        private String keyMarker;

        private String versionIdMarker;

        private String nextKeyMarker;

        private String nextVersionIdMarker;

        private List<ObjectVersion> versions = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteMarkerEntry> deleteMarkers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String prefix;

        private String delimiter;

        private Integer maxKeys;

        private List<CommonPrefix> commonPrefixes = DefaultSdkAutoConstructList.getInstance();

        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectVersionsResponse model) {
            super(model);
            isTruncated(model.isTruncated);
            keyMarker(model.keyMarker);
            versionIdMarker(model.versionIdMarker);
            nextKeyMarker(model.nextKeyMarker);
            nextVersionIdMarker(model.nextVersionIdMarker);
            versions(model.versions);
            deleteMarkers(model.deleteMarkers);
            name(model.name);
            prefix(model.prefix);
            delimiter(model.delimiter);
            maxKeys(model.maxKeys);
            commonPrefixes(model.commonPrefixes);
            encodingType(model.encodingType);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getKeyMarker() {
            return keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getVersionIdMarker() {
            return versionIdMarker;
        }

        @Override
        public final Builder versionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
            return this;
        }

        public final void setVersionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
        }

        public final String getNextKeyMarker() {
            return nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getNextVersionIdMarker() {
            return nextVersionIdMarker;
        }

        @Override
        public final Builder nextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
            return this;
        }

        public final void setNextVersionIdMarker(String nextVersionIdMarker) {
            this.nextVersionIdMarker = nextVersionIdMarker;
        }

        public final Collection<ObjectVersion.Builder> getVersions() {
            return versions != null ? versions.stream().map(ObjectVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<ObjectVersion> versions) {
            this.versions = ObjectVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(ObjectVersion... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<ObjectVersion.Builder>... versions) {
            versions(Stream.of(versions).map(c -> ObjectVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<ObjectVersion.BuilderImpl> versions) {
            this.versions = ObjectVersionListCopier.copyFromBuilder(versions);
        }

        public final Collection<DeleteMarkerEntry.Builder> getDeleteMarkers() {
            return deleteMarkers != null ? deleteMarkers.stream().map(DeleteMarkerEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder deleteMarkers(Collection<DeleteMarkerEntry> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copy(deleteMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMarkers(DeleteMarkerEntry... deleteMarkers) {
            deleteMarkers(Arrays.asList(deleteMarkers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMarkers(Consumer<DeleteMarkerEntry.Builder>... deleteMarkers) {
            deleteMarkers(Stream.of(deleteMarkers).map(c -> DeleteMarkerEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeleteMarkers(Collection<DeleteMarkerEntry.BuilderImpl> deleteMarkers) {
            this.deleteMarkers = DeleteMarkersCopier.copyFromBuilder(deleteMarkers);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix.Builder> getCommonPrefixes() {
            return commonPrefixes != null ? commonPrefixes.stream().map(CommonPrefix::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix... commonPrefixes) {
            commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(Consumer<CommonPrefix.Builder>... commonPrefixes) {
            commonPrefixes(Stream.of(commonPrefixes).map(c -> CommonPrefix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix.BuilderImpl> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copyFromBuilder(commonPrefixes);
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        @Override
        public ListObjectVersionsResponse build() {
            return new ListObjectVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
