/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter that identifies subset of objects to which the replication rule applies. A <code>Filter</code> must specify
 * exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRuleFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationRuleFilter.Builder, ReplicationRuleFilter> {
    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationRuleFilter::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<Tag> TAG_FIELD = SdkField
            .<Tag> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationRuleFilter::tag))
            .setter(setter(Builder::tag))
            .constructor(Tag::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag")
                    .build()).build();

    private static final SdkField<ReplicationRuleAndOperator> AND_FIELD = SdkField
            .<ReplicationRuleAndOperator> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplicationRuleFilter::and))
            .setter(setter(Builder::and))
            .constructor(ReplicationRuleAndOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").unmarshallLocationName("And")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, TAG_FIELD,
            AND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final Tag tag;

    private final ReplicationRuleAndOperator and;

    private ReplicationRuleFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * <p>
     * Object keyname prefix that identifies subset of objects to which the rule applies.
     * </p>
     * 
     * @return Object keyname prefix that identifies subset of objects to which the rule applies.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * Container for specifying a tag key and value.
     * </p>
     * <p>
     * The rule applies only to objects having the tag in its tagset.
     * </p>
     * 
     * @return Container for specifying a tag key and value. </p>
     *         <p>
     *         The rule applies only to objects having the tag in its tagset.
     */
    public Tag tag() {
        return tag;
    }

    /**
     * <p>
     * Container for specifying rule filters. These filters determine the subset of objects to which the rule applies.
     * The element is required only if you specify more than one filter. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You specify both a <code>Prefix</code> and a <code>Tag</code> filters. Then you wrap these in an <code>And</code>
     * tag.
     * </p>
     * </li>
     * <li>
     * <p>
     * You specify filter based on multiple tags. Then you wrap the <code>Tag</code> elements in an <code>And</code>
     * tag.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Container for specifying rule filters. These filters determine the subset of objects to which the rule
     *         applies. The element is required only if you specify more than one filter. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specify both a <code>Prefix</code> and a <code>Tag</code> filters. Then you wrap these in an
     *         <code>And</code> tag.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You specify filter based on multiple tags. Then you wrap the <code>Tag</code> elements in an
     *         <code>And</code> tag.
     *         </p>
     *         </li>
     */
    public ReplicationRuleAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(and());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRuleFilter)) {
            return false;
        }
        ReplicationRuleFilter other = (ReplicationRuleFilter) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(and(), other.and());
    }

    @Override
    public String toString() {
        return ToString.builder("ReplicationRuleFilter").add("Prefix", prefix()).add("Tag", tag()).add("And", and()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRuleFilter, T> g) {
        return obj -> g.apply((ReplicationRuleFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRuleFilter> {
        /**
         * <p>
         * Object keyname prefix that identifies subset of objects to which the rule applies.
         * </p>
         * 
         * @param prefix
         *        Object keyname prefix that identifies subset of objects to which the rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * Container for specifying a tag key and value.
         * </p>
         * <p>
         * The rule applies only to objects having the tag in its tagset.
         * </p>
         * 
         * @param tag
         *        Container for specifying a tag key and value. </p>
         *        <p>
         *        The rule applies only to objects having the tag in its tagset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(Tag tag);

        /**
         * <p>
         * Container for specifying a tag key and value.
         * </p>
         * <p>
         * The rule applies only to objects having the tag in its tagset.
         * </p>
         * This is a convenience that creates an instance of the {@link Tag.Builder} avoiding the need to create one
         * manually via {@link Tag#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tag.Builder#build()} is called immediately and its result is
         * passed to {@link #tag(Tag)}.
         * 
         * @param tag
         *        a consumer that will call methods on {@link Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(Tag)
         */
        default Builder tag(Consumer<Tag.Builder> tag) {
            return tag(Tag.builder().applyMutation(tag).build());
        }

        /**
         * <p>
         * Container for specifying rule filters. These filters determine the subset of objects to which the rule
         * applies. The element is required only if you specify more than one filter. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You specify both a <code>Prefix</code> and a <code>Tag</code> filters. Then you wrap these in an
         * <code>And</code> tag.
         * </p>
         * </li>
         * <li>
         * <p>
         * You specify filter based on multiple tags. Then you wrap the <code>Tag</code> elements in an <code>And</code>
         * tag.
         * </p>
         * </li>
         * </ul>
         * 
         * @param and
         *        Container for specifying rule filters. These filters determine the subset of objects to which the rule
         *        applies. The element is required only if you specify more than one filter. For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You specify both a <code>Prefix</code> and a <code>Tag</code> filters. Then you wrap these in an
         *        <code>And</code> tag.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You specify filter based on multiple tags. Then you wrap the <code>Tag</code> elements in an
         *        <code>And</code> tag.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(ReplicationRuleAndOperator and);

        /**
         * <p>
         * Container for specifying rule filters. These filters determine the subset of objects to which the rule
         * applies. The element is required only if you specify more than one filter. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You specify both a <code>Prefix</code> and a <code>Tag</code> filters. Then you wrap these in an
         * <code>And</code> tag.
         * </p>
         * </li>
         * <li>
         * <p>
         * You specify filter based on multiple tags. Then you wrap the <code>Tag</code> elements in an <code>And</code>
         * tag.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ReplicationRuleAndOperator.Builder} avoiding the
         * need to create one manually via {@link ReplicationRuleAndOperator#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationRuleAndOperator.Builder#build()} is called immediately
         * and its result is passed to {@link #and(ReplicationRuleAndOperator)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link ReplicationRuleAndOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(ReplicationRuleAndOperator)
         */
        default Builder and(Consumer<ReplicationRuleAndOperator.Builder> and) {
            return and(ReplicationRuleAndOperator.builder().applyMutation(and).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private Tag tag;

        private ReplicationRuleAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRuleFilter model) {
            prefix(model.prefix);
            tag(model.tag);
            and(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final ReplicationRuleAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        @Override
        public final Builder and(ReplicationRuleAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(ReplicationRuleAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public ReplicationRuleFilter build() {
            return new ReplicationRuleFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
