/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicConfigurationDeprecated implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicConfigurationDeprecated.Builder, TopicConfigurationDeprecated> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TopicConfigurationDeprecated::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TopicConfigurationDeprecated::eventsAsStrings))
            .setter(setter(Builder::eventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events")
                    .unmarshallLocationName("Event").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TopicConfigurationDeprecated::eventAsString))
            .setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event")
                    .unmarshallLocationName("Event").build()).build();

    private static final SdkField<String> TOPIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TopicConfigurationDeprecated::topic))
            .setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic")
                    .unmarshallLocationName("Topic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENTS_FIELD,
            EVENT_FIELD, TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<String> events;

    private final String event;

    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<Event> events() {
        return TypeConverter.convert(events, Event::fromValue);
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<String> eventsAsStrings() {
        return events;
    }

    /**
     * <p>
     * Bucket event for which to send notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Bucket event for which to send notifications.
     * @see Event
     */
    public Event event() {
        return Event.fromValue(event);
    }

    /**
     * <p>
     * Bucket event for which to send notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Bucket event for which to send notifications.
     * @see Event
     */
    public String eventAsString() {
        return event;
    }

    /**
     * <p>
     * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     * </p>
     * 
     * @return Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     */
    public String topic() {
        return topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(eventsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(eventsAsStrings(), other.eventsAsStrings())
                && Objects.equals(eventAsString(), other.eventAsString()) && Objects.equals(topic(), other.topic());
    }

    @Override
    public String toString() {
        return ToString.builder("TopicConfigurationDeprecated").add("Id", id()).add("Events", eventsAsStrings())
                .add("Event", eventAsString()).add("Topic", topic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Events":
            return Optional.ofNullable(clazz.cast(eventsAsStrings()));
        case "Event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "Topic":
            return Optional.ofNullable(clazz.cast(topic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicConfigurationDeprecated, T> g) {
        return obj -> g.apply((TopicConfigurationDeprecated) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(Collection<String> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(String... events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * Bucket event for which to send notifications.
         * </p>
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * <p>
         * Bucket event for which to send notifications.
         * </p>
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * <p>
         * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
         * </p>
         * 
         * @param topic
         *        Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private String event;

        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            id(model.id);
            eventsWithStrings(model.events);
            event(model.event);
            topic(model.topic);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String... events) {
            eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
