/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkProtectedApi
public final class DecodeUrlEncodedResponseInterceptor
implements ExecutionInterceptor {
    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse response = context.response();
        if (DecodeUrlEncodedResponseInterceptor.shouldHandle(response)) {
            if (response instanceof ListObjectsResponse) {
                response = DecodeUrlEncodedResponseInterceptor.modifyListObjectsResponse((ListObjectsResponse)response);
            } else if (response instanceof ListObjectsV2Response) {
                response = DecodeUrlEncodedResponseInterceptor.modifyListObjectsV2Response((ListObjectsV2Response)response);
            }
        }
        return response;
    }

    private static boolean shouldHandle(SdkResponse sdkResponse) {
        return sdkResponse.getValueForField("EncodingType", String.class).map(et -> EncodingType.URL.toString().equals(et)).orElse(false);
    }

    private static SdkResponse modifyListObjectsResponse(ListObjectsResponse response) {
        return (SdkResponse)response.toBuilder().delimiter(SdkHttpUtils.urlDecode((String)response.delimiter())).marker(SdkHttpUtils.urlDecode((String)response.delimiter())).prefix(SdkHttpUtils.urlDecode((String)response.prefix())).nextMarker(SdkHttpUtils.urlDecode((String)response.nextMarker())).contents(DecodeUrlEncodedResponseInterceptor.decodeContents(response.contents())).build();
    }

    private static SdkResponse modifyListObjectsV2Response(ListObjectsV2Response response) {
        return (SdkResponse)response.toBuilder().delimiter(SdkHttpUtils.urlDecode((String)response.delimiter())).prefix(SdkHttpUtils.urlDecode((String)response.prefix())).startAfter(SdkHttpUtils.urlDecode((String)response.startAfter())).contents(DecodeUrlEncodedResponseInterceptor.decodeContents(response.contents())).build();
    }

    private static List<S3Object> decodeContents(List<S3Object> contents) {
        if (contents == null) {
            return null;
        }
        return contents.stream().map(o -> (S3Object)o.toBuilder().key(SdkHttpUtils.urlDecode((String)o.key())).build()).collect(Collectors.toList());
    }
}

