/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.InputStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringInputStream;

@SdkInternalApi
public final class GetBucketPolicyInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullResponse modifyHttpResponse(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetBucketPolicyRequest) {
            String policy = context.httpResponse().content().map(c -> (String)FunctionalUtils.invokeSafely(() -> IoUtils.toUtf8String((InputStream)c))).orElse(null);
            String xml = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Policy><![CDATA[%s]]></Policy>", policy);
            return (SdkHttpFullResponse)((SdkHttpFullResponse.Builder)context.httpResponse().toBuilder()).content(AbortableInputStream.create((InputStream)new StringInputStream(xml))).build();
        }
        return context.httpResponse();
    }
}

