/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.ExpirationStatus;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<LifecycleExpiration> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Rule.getter(Rule::expiration)).setter(Rule.setter(Builder::expiration)).constructor(LifecycleExpiration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").unmarshallLocationName("Expiration").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Rule.getter(Rule::id)).setter(Rule.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ID").unmarshallLocationName("ID").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Rule.getter(Rule::prefix)).setter(Rule.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Rule.getter(Rule::statusAsString)).setter(Rule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Transition> TRANSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Rule.getter(Rule::transition)).setter(Rule.setter(Builder::transition)).constructor(Transition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transition").unmarshallLocationName("Transition").build()}).build();
    private static final SdkField<NoncurrentVersionTransition> NONCURRENT_VERSION_TRANSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Rule.getter(Rule::noncurrentVersionTransition)).setter(Rule.setter(Builder::noncurrentVersionTransition)).constructor(NoncurrentVersionTransition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionTransition").unmarshallLocationName("NoncurrentVersionTransition").build()}).build();
    private static final SdkField<NoncurrentVersionExpiration> NONCURRENT_VERSION_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Rule.getter(Rule::noncurrentVersionExpiration)).setter(Rule.setter(Builder::noncurrentVersionExpiration)).constructor(NoncurrentVersionExpiration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoncurrentVersionExpiration").unmarshallLocationName("NoncurrentVersionExpiration").build()}).build();
    private static final SdkField<AbortIncompleteMultipartUpload> ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Rule.getter(Rule::abortIncompleteMultipartUpload)).setter(Rule.setter(Builder::abortIncompleteMultipartUpload)).constructor(AbortIncompleteMultipartUpload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortIncompleteMultipartUpload").unmarshallLocationName("AbortIncompleteMultipartUpload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_FIELD, ID_FIELD, PREFIX_FIELD, STATUS_FIELD, TRANSITION_FIELD, NONCURRENT_VERSION_TRANSITION_FIELD, NONCURRENT_VERSION_EXPIRATION_FIELD, ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final LifecycleExpiration expiration;
    private final String id;
    private final String prefix;
    private final String status;
    private final Transition transition;
    private final NoncurrentVersionTransition noncurrentVersionTransition;
    private final NoncurrentVersionExpiration noncurrentVersionExpiration;
    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private Rule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.transition = builder.transition;
        this.noncurrentVersionTransition = builder.noncurrentVersionTransition;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    public LifecycleExpiration expiration() {
        return this.expiration;
    }

    public String id() {
        return this.id;
    }

    public String prefix() {
        return this.prefix;
    }

    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Transition transition() {
        return this.transition;
    }

    public NoncurrentVersionTransition noncurrentVersionTransition() {
        return this.noncurrentVersionTransition;
    }

    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return this.noncurrentVersionExpiration;
    }

    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return this.abortIncompleteMultipartUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transition());
        hashCode = 31 * hashCode + Objects.hashCode(this.noncurrentVersionTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.noncurrentVersionExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortIncompleteMultipartUpload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.transition(), other.transition()) && Objects.equals(this.noncurrentVersionTransition(), other.noncurrentVersionTransition()) && Objects.equals(this.noncurrentVersionExpiration(), other.noncurrentVersionExpiration()) && Objects.equals(this.abortIncompleteMultipartUpload(), other.abortIncompleteMultipartUpload());
    }

    public String toString() {
        return ToString.builder((String)"Rule").add("Expiration", (Object)this.expiration()).add("ID", (Object)this.id()).add("Prefix", (Object)this.prefix()).add("Status", (Object)this.statusAsString()).add("Transition", (Object)this.transition()).add("NoncurrentVersionTransition", (Object)this.noncurrentVersionTransition()).add("NoncurrentVersionExpiration", (Object)this.noncurrentVersionExpiration()).add("AbortIncompleteMultipartUpload", (Object)this.abortIncompleteMultipartUpload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "ID": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Transition": {
                return Optional.ofNullable(clazz.cast(this.transition()));
            }
            case "NoncurrentVersionTransition": {
                return Optional.ofNullable(clazz.cast(this.noncurrentVersionTransition()));
            }
            case "NoncurrentVersionExpiration": {
                return Optional.ofNullable(clazz.cast(this.noncurrentVersionExpiration()));
            }
            case "AbortIncompleteMultipartUpload": {
                return Optional.ofNullable(clazz.cast(this.abortIncompleteMultipartUpload()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LifecycleExpiration expiration;
        private String id;
        private String prefix;
        private String status;
        private Transition transition;
        private NoncurrentVersionTransition noncurrentVersionTransition;
        private NoncurrentVersionExpiration noncurrentVersionExpiration;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.expiration(model.expiration);
            this.id(model.id);
            this.prefix(model.prefix);
            this.status(model.status);
            this.transition(model.transition);
            this.noncurrentVersionTransition(model.noncurrentVersionTransition);
            this.noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            this.abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return this.expiration != null ? this.expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Transition.Builder getTransition() {
            return this.transition != null ? this.transition.toBuilder() : null;
        }

        @Override
        public final Builder transition(Transition transition) {
            this.transition = transition;
            return this;
        }

        public final void setTransition(Transition.BuilderImpl transition) {
            this.transition = transition != null ? transition.build() : null;
        }

        public final NoncurrentVersionTransition.Builder getNoncurrentVersionTransition() {
            return this.noncurrentVersionTransition != null ? this.noncurrentVersionTransition.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
            return this;
        }

        public final void setNoncurrentVersionTransition(NoncurrentVersionTransition.BuilderImpl noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition != null ? noncurrentVersionTransition.build() : null;
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration != null ? this.noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build() : null;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder expiration(LifecycleExpiration var1);

        default public Builder expiration(Consumer<LifecycleExpiration.Builder> expiration) {
            return this.expiration((LifecycleExpiration)((LifecycleExpiration.Builder)LifecycleExpiration.builder().applyMutation(expiration)).build());
        }

        public Builder id(String var1);

        public Builder prefix(String var1);

        public Builder status(String var1);

        public Builder status(ExpirationStatus var1);

        public Builder transition(Transition var1);

        default public Builder transition(Consumer<Transition.Builder> transition) {
            return this.transition((Transition)((Transition.Builder)Transition.builder().applyMutation(transition)).build());
        }

        public Builder noncurrentVersionTransition(NoncurrentVersionTransition var1);

        default public Builder noncurrentVersionTransition(Consumer<NoncurrentVersionTransition.Builder> noncurrentVersionTransition) {
            return this.noncurrentVersionTransition((NoncurrentVersionTransition)((NoncurrentVersionTransition.Builder)NoncurrentVersionTransition.builder().applyMutation(noncurrentVersionTransition)).build());
        }

        public Builder noncurrentVersionExpiration(NoncurrentVersionExpiration var1);

        default public Builder noncurrentVersionExpiration(Consumer<NoncurrentVersionExpiration.Builder> noncurrentVersionExpiration) {
            return this.noncurrentVersionExpiration((NoncurrentVersionExpiration)((NoncurrentVersionExpiration.Builder)NoncurrentVersionExpiration.builder().applyMutation(noncurrentVersionExpiration)).build());
        }

        public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload var1);

        default public Builder abortIncompleteMultipartUpload(Consumer<AbortIncompleteMultipartUpload.Builder> abortIncompleteMultipartUpload) {
            return this.abortIncompleteMultipartUpload((AbortIncompleteMultipartUpload)((AbortIncompleteMultipartUpload.Builder)AbortIncompleteMultipartUpload.builder().applyMutation(abortIncompleteMultipartUpload)).build());
        }
    }
}

