/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicConfigurationDeprecated
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicConfigurationDeprecated> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicConfigurationDeprecated.getter(TopicConfigurationDeprecated::id)).setter(TopicConfigurationDeprecated.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TopicConfigurationDeprecated.getter(TopicConfigurationDeprecated::eventsAsStrings)).setter(TopicConfigurationDeprecated.setter(Builder::eventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").unmarshallLocationName("Event").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicConfigurationDeprecated.getter(TopicConfigurationDeprecated::eventAsString)).setter(TopicConfigurationDeprecated.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").unmarshallLocationName("Event").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicConfigurationDeprecated.getter(TopicConfigurationDeprecated::topic)).setter(TopicConfigurationDeprecated.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").unmarshallLocationName("Topic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENTS_FIELD, EVENT_FIELD, TOPIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> events;
    private final String event;
    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    public String id() {
        return this.id;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsAsStrings() {
        return this.events;
    }

    public Event event() {
        return Event.fromValue(this.event);
    }

    public String eventAsString() {
        return this.event;
    }

    public String topic() {
        return this.topic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.eventsAsStrings(), other.eventsAsStrings()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.topic(), other.topic());
    }

    public String toString() {
        return ToString.builder((String)"TopicConfigurationDeprecated").add("Id", (Object)this.id()).add("Events", this.eventsAsStrings()).add("Event", (Object)this.eventAsString()).add("Topic", (Object)this.topic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.eventsAsStrings()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "Topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicConfigurationDeprecated, T> g) {
        return obj -> g.apply((TopicConfigurationDeprecated)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> events = DefaultSdkAutoConstructList.getInstance();
        private String event;
        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            this.id(model.id);
            this.eventsWithStrings(model.events);
            this.event(model.event);
            this.topic(model.topic);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String ... events) {
            this.eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder eventsWithStrings(Collection<String> var1);

        public Builder eventsWithStrings(String ... var1);

        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder topic(String var1);
    }
}

