/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyObjectResult implements ToCopyableBuilder<CopyObjectResult.Builder, CopyObjectResult> {
    private final String eTag;

    private final Instant lastModified;

    private CopyObjectResult(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
    }

    /**
     * Returns the value of the ETag property for this object.
     * 
     * @return The value of the ETag property for this object.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * Returns the value of the LastModified property for this object.
     * 
     * @return The value of the LastModified property for this object.
     */
    public Instant lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        hashCode = 31 * hashCode + ((lastModified() == null) ? 0 : lastModified().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyObjectResult)) {
            return false;
        }
        CopyObjectResult other = (CopyObjectResult) obj;
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (lastModified() != null) {
            sb.append("LastModified: ").append(lastModified()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CopyObjectResult> {
        /**
         * Sets the value of the ETag property for this object.
         *
         * @param eTag
         *        The new value for the ETag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * Sets the value of the LastModified property for this object.
         *
         * @param lastModified
         *        The new value for the LastModified property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);
    }

    private static final class BuilderImpl implements Builder {
        private String eTag;

        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyObjectResult model) {
            setETag(model.eTag);
            setLastModified(model.lastModified);
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public CopyObjectResult build() {
            return new CopyObjectResult(this);
        }
    }
}
