/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketInventoryConfigurationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListBucketInventoryConfigurationsRequest.Builder, ListBucketInventoryConfigurationsRequest> {
    private final String bucket;

    private final String continuationToken;

    private ListBucketInventoryConfigurationsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * The name of the bucket containing the inventory configurations to retrieve.
     * 
     * @return The name of the bucket containing the inventory configurations to retrieve.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The marker used to continue an inventory configuration listing that has been truncated. Use the
     * NextContinuationToken from a previously truncated list response to continue the listing. The continuation token
     * is an opaque value that Amazon S3 understands.
     * 
     * @return The marker used to continue an inventory configuration listing that has been truncated. Use the
     *         NextContinuationToken from a previously truncated list response to continue the listing. The continuation
     *         token is an opaque value that Amazon S3 understands.
     */
    public String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((continuationToken() == null) ? 0 : continuationToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketInventoryConfigurationsRequest)) {
            return false;
        }
        ListBucketInventoryConfigurationsRequest other = (ListBucketInventoryConfigurationsRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketInventoryConfigurationsRequest> {
        /**
         * The name of the bucket containing the inventory configurations to retrieve.
         * 
         * @param bucket
         *        The name of the bucket containing the inventory configurations to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The marker used to continue an inventory configuration listing that has been truncated. Use the
         * NextContinuationToken from a previously truncated list response to continue the listing. The continuation
         * token is an opaque value that Amazon S3 understands.
         * 
         * @param continuationToken
         *        The marker used to continue an inventory configuration listing that has been truncated. Use the
         *        NextContinuationToken from a previously truncated list response to continue the listing. The
         *        continuation token is an opaque value that Amazon S3 understands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketInventoryConfigurationsRequest model) {
            setBucket(model.bucket);
            setContinuationToken(model.continuationToken);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public ListBucketInventoryConfigurationsRequest build() {
            return new ListBucketInventoryConfigurationsRequest(this);
        }
    }
}
