/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * ListObjectVersionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectVersionsRequestMarshaller implements
        Marshaller<Request<ListObjectVersionsRequest>, ListObjectVersionsRequest> {

    public Request<ListObjectVersionsRequest> marshall(ListObjectVersionsRequest listObjectVersionsRequest) {

        if (listObjectVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListObjectVersionsRequest> request = new DefaultRequest<ListObjectVersionsRequest>(listObjectVersionsRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/{Bucket}?versions";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                listObjectVersionsRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (listObjectVersionsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString(listObjectVersionsRequest.delimiter()));
        }

        if (listObjectVersionsRequest.encodingType() != null) {
            request.addParameter("encoding-type", StringUtils.fromString(listObjectVersionsRequest.encodingType()));
        }

        if (listObjectVersionsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringUtils.fromString(listObjectVersionsRequest.keyMarker()));
        }

        if (listObjectVersionsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger(listObjectVersionsRequest.maxKeys()));
        }

        if (listObjectVersionsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString(listObjectVersionsRequest.prefix()));
        }

        if (listObjectVersionsRequest.versionIdMarker() != null) {
            request.addParameter("version-id-marker", StringUtils.fromString(listObjectVersionsRequest.versionIdMarker()));
        }

        return request;
    }

}