/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * S3KeyFilter StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class S3KeyFilterUnmarshaller implements Unmarshaller<S3KeyFilter, StaxUnmarshallerContext> {

    public S3KeyFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3KeyFilter.Builder s3KeyFilter = S3KeyFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<FilterRule> filterRules = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                s3KeyFilter.filterRules(filterRules);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FilterRule", targetDepth)) {
                    if (filterRules == null) {
                        filterRules = new ArrayList<>();
                    }
                    filterRules.add(FilterRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    s3KeyFilter.filterRules(filterRules);
                    break;
                }
            }
        }
        return s3KeyFilter.build();
    }

    private static S3KeyFilterUnmarshaller INSTANCE;

    public static S3KeyFilterUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new S3KeyFilterUnmarshaller();
        return INSTANCE;
    }
}
