/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies the days since the initiation of an Incomplete Multipart Upload that Lifecycle will wait before permanently
 * removing all parts of the upload.
 */
@Generated("software.amazon.awssdk:codegen")
public class AbortIncompleteMultipartUpload implements
        ToCopyableBuilder<AbortIncompleteMultipartUpload.Builder, AbortIncompleteMultipartUpload> {
    private final Integer daysAfterInitiation;

    private AbortIncompleteMultipartUpload(BuilderImpl builder) {
        this.daysAfterInitiation = builder.daysAfterInitiation;
    }

    /**
     * Indicates the number of days that must pass since initiation for Lifecycle to abort an Incomplete Multipart
     * Upload.
     * 
     * @return Indicates the number of days that must pass since initiation for Lifecycle to abort an Incomplete
     *         Multipart Upload.
     */
    public Integer daysAfterInitiation() {
        return daysAfterInitiation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((daysAfterInitiation() == null) ? 0 : daysAfterInitiation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortIncompleteMultipartUpload)) {
            return false;
        }
        AbortIncompleteMultipartUpload other = (AbortIncompleteMultipartUpload) obj;
        if (other.daysAfterInitiation() == null ^ this.daysAfterInitiation() == null) {
            return false;
        }
        if (other.daysAfterInitiation() != null && !other.daysAfterInitiation().equals(this.daysAfterInitiation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (daysAfterInitiation() != null) {
            sb.append("DaysAfterInitiation: ").append(daysAfterInitiation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DaysAfterInitiation":
            return Optional.of(clazz.cast(daysAfterInitiation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AbortIncompleteMultipartUpload> {
        /**
         * Indicates the number of days that must pass since initiation for Lifecycle to abort an Incomplete Multipart
         * Upload.
         * 
         * @param daysAfterInitiation
         *        Indicates the number of days that must pass since initiation for Lifecycle to abort an Incomplete
         *        Multipart Upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysAfterInitiation(Integer daysAfterInitiation);
    }

    static final class BuilderImpl implements Builder {
        private Integer daysAfterInitiation;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortIncompleteMultipartUpload model) {
            daysAfterInitiation(model.daysAfterInitiation);
        }

        public final Integer getDaysAfterInitiation() {
            return daysAfterInitiation;
        }

        @Override
        public final Builder daysAfterInitiation(Integer daysAfterInitiation) {
            this.daysAfterInitiation = daysAfterInitiation;
            return this;
        }

        public final void setDaysAfterInitiation(Integer daysAfterInitiation) {
            this.daysAfterInitiation = daysAfterInitiation;
        }

        @Override
        public AbortIncompleteMultipartUpload build() {
            return new AbortIncompleteMultipartUpload(this);
        }
    }
}
