/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AbortMultipartUploadRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AbortMultipartUploadRequest.Builder, AbortMultipartUploadRequest> {
    private final String bucket;

    private final String key;

    private final String uploadId;

    private final String requestPayer;

    private AbortMultipartUploadRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.requestPayer = builder.requestPayer;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * Returns the value of the UploadId property for this object.
     * 
     * @return The value of the UploadId property for this object.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerString() {
        return requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((requestPayerString() == null) ? 0 : requestPayerString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortMultipartUploadRequest)) {
            return false;
        }
        AbortMultipartUploadRequest other = (AbortMultipartUploadRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        if (other.requestPayerString() != null && !other.requestPayerString().equals(this.requestPayerString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (requestPayerString() != null) {
            sb.append("RequestPayer: ").append(requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "UploadId":
            return Optional.of(clazz.cast(uploadId()));
        case "RequestPayer":
            return Optional.of(clazz.cast(requestPayerString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AbortMultipartUploadRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the UploadId property for this object.
         *
         * @param uploadId
         *        The new value for the UploadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String uploadId;

        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortMultipartUploadRequest model) {
            bucket(model.bucket);
            key(model.key);
            uploadId(model.uploadId);
            requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public AbortMultipartUploadRequest build() {
            return new AbortMultipartUploadRequest(this);
        }
    }
}
