/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateMultipartUploadResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateMultipartUploadResponse.Builder, CreateMultipartUploadResponse> {
    private final Instant abortDate;

    private final String abortRuleId;

    private final String bucket;

    private final String key;

    private final String uploadId;

    private final String serverSideEncryption;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKeyMD5;

    private final String ssekmsKeyId;

    private final String requestCharged;

    private CreateMultipartUploadResponse(BuilderImpl builder) {
        this.abortDate = builder.abortDate;
        this.abortRuleId = builder.abortRuleId;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * Date when multipart upload will become eligible for abort operation by lifecycle.
     * 
     * @return Date when multipart upload will become eligible for abort operation by lifecycle.
     */
    public Instant abortDate() {
        return abortDate;
    }

    /**
     * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     * 
     * @return Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     */
    public String abortRuleId() {
        return abortRuleId;
    }

    /**
     * Name of the bucket to which the multipart upload was initiated.
     * 
     * @return Name of the bucket to which the multipart upload was initiated.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Object key for which the multipart upload was initiated.
     * 
     * @return Object key for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * ID for the initiated multipart upload.
     * 
     * @return ID for the initiated multipart upload.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverSideEncryption} will return {@link ServerSideEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverSideEncryptionString}.
     * </p>
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(serverSideEncryption);
    }

    /**
     * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverSideEncryption} will return {@link ServerSideEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverSideEncryptionString}.
     * </p>
     * 
     * @return The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
     * @see ServerSideEncryption
     */
    public String serverSideEncryptionString() {
        return serverSideEncryption;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header confirming the encryption algorithm used.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header confirming the encryption algorithm used.
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this
     * header to provide round trip message integrity verification of the customer-provided encryption key.
     * 
     * @return If server-side encryption with a customer-provided encryption key was requested, the response will
     *         include this header to provide round trip message integrity verification of the customer-provided
     *         encryption key.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for the
     * object.
     * 
     * @return If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used
     *         for the object.
     */
    public String ssekmsKeyId() {
        return ssekmsKeyId;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(requestCharged);
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestChargedString() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((abortDate() == null) ? 0 : abortDate().hashCode());
        hashCode = 31 * hashCode + ((abortRuleId() == null) ? 0 : abortRuleId().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((serverSideEncryptionString() == null) ? 0 : serverSideEncryptionString().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((ssekmsKeyId() == null) ? 0 : ssekmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((requestChargedString() == null) ? 0 : requestChargedString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartUploadResponse)) {
            return false;
        }
        CreateMultipartUploadResponse other = (CreateMultipartUploadResponse) obj;
        if (other.abortDate() == null ^ this.abortDate() == null) {
            return false;
        }
        if (other.abortDate() != null && !other.abortDate().equals(this.abortDate())) {
            return false;
        }
        if (other.abortRuleId() == null ^ this.abortRuleId() == null) {
            return false;
        }
        if (other.abortRuleId() != null && !other.abortRuleId().equals(this.abortRuleId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.serverSideEncryptionString() == null ^ this.serverSideEncryptionString() == null) {
            return false;
        }
        if (other.serverSideEncryptionString() != null
                && !other.serverSideEncryptionString().equals(this.serverSideEncryptionString())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.ssekmsKeyId() == null ^ this.ssekmsKeyId() == null) {
            return false;
        }
        if (other.ssekmsKeyId() != null && !other.ssekmsKeyId().equals(this.ssekmsKeyId())) {
            return false;
        }
        if (other.requestChargedString() == null ^ this.requestChargedString() == null) {
            return false;
        }
        if (other.requestChargedString() != null && !other.requestChargedString().equals(this.requestChargedString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (abortDate() != null) {
            sb.append("AbortDate: ").append(abortDate()).append(",");
        }
        if (abortRuleId() != null) {
            sb.append("AbortRuleId: ").append(abortRuleId()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (serverSideEncryptionString() != null) {
            sb.append("ServerSideEncryption: ").append(serverSideEncryptionString()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(ssekmsKeyId()).append(",");
        }
        if (requestChargedString() != null) {
            sb.append("RequestCharged: ").append(requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbortDate":
            return Optional.of(clazz.cast(abortDate()));
        case "AbortRuleId":
            return Optional.of(clazz.cast(abortRuleId()));
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "UploadId":
            return Optional.of(clazz.cast(uploadId()));
        case "ServerSideEncryption":
            return Optional.of(clazz.cast(serverSideEncryptionString()));
        case "SSECustomerAlgorithm":
            return Optional.of(clazz.cast(sseCustomerAlgorithm()));
        case "SSECustomerKeyMD5":
            return Optional.of(clazz.cast(sseCustomerKeyMD5()));
        case "SSEKMSKeyId":
            return Optional.of(clazz.cast(ssekmsKeyId()));
        case "RequestCharged":
            return Optional.of(clazz.cast(requestChargedString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateMultipartUploadResponse> {
        /**
         * Date when multipart upload will become eligible for abort operation by lifecycle.
         * 
         * @param abortDate
         *        Date when multipart upload will become eligible for abort operation by lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortDate(Instant abortDate);

        /**
         * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * 
         * @param abortRuleId
         *        Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortRuleId(String abortRuleId);

        /**
         * Name of the bucket to which the multipart upload was initiated.
         * 
         * @param bucket
         *        Name of the bucket to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Object key for which the multipart upload was initiated.
         * 
         * @param key
         *        Object key for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * ID for the initiated multipart upload.
         * 
         * @param uploadId
         *        ID for the initiated multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(String serverSideEncryption);

        /**
         * The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * 
         * @param serverSideEncryption
         *        The Server-side encryption algorithm used when storing this object in S3 (e.g., AES256, aws:kms).
         * @see ServerSideEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryption
         */
        Builder serverSideEncryption(ServerSideEncryption serverSideEncryption);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header confirming the encryption algorithm used.
         * 
         * @param sseCustomerAlgorithm
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header confirming the encryption algorithm used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include
         * this header to provide round trip message integrity verification of the customer-provided encryption key.
         * 
         * @param sseCustomerKeyMD5
         *        If server-side encryption with a customer-provided encryption key was requested, the response will
         *        include this header to provide round trip message integrity verification of the customer-provided
         *        encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was used for
         * the object.
         * 
         * @param ssekmsKeyId
         *        If present, specifies the ID of the AWS Key Management Service (KMS) master encryption key that was
         *        used for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekmsKeyId(String ssekmsKeyId);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    static final class BuilderImpl implements Builder {
        private Instant abortDate;

        private String abortRuleId;

        private String bucket;

        private String key;

        private String uploadId;

        private String serverSideEncryption;

        private String sseCustomerAlgorithm;

        private String sseCustomerKeyMD5;

        private String ssekmsKeyId;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartUploadResponse model) {
            abortDate(model.abortDate);
            abortRuleId(model.abortRuleId);
            bucket(model.bucket);
            key(model.key);
            uploadId(model.uploadId);
            serverSideEncryption(model.serverSideEncryption);
            sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            ssekmsKeyId(model.ssekmsKeyId);
            requestCharged(model.requestCharged);
        }

        public final Instant getAbortDate() {
            return abortDate;
        }

        @Override
        public final Builder abortDate(Instant abortDate) {
            this.abortDate = abortDate;
            return this;
        }

        public final void setAbortDate(Instant abortDate) {
            this.abortDate = abortDate;
        }

        public final String getAbortRuleId() {
            return abortRuleId;
        }

        @Override
        public final Builder abortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
            return this;
        }

        public final void setAbortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getServerSideEncryption() {
            return serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public CreateMultipartUploadResponse build() {
            return new CreateMultipartUploadResponse(this);
        }
    }
}
