/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteBucketAnalyticsConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteBucketAnalyticsConfigurationRequest.Builder, DeleteBucketAnalyticsConfigurationRequest> {
    private final String bucket;

    private final String id;

    private DeleteBucketAnalyticsConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.id = builder.id;
    }

    /**
     * The name of the bucket from which an analytics configuration is deleted.
     * 
     * @return The name of the bucket from which an analytics configuration is deleted.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The identifier used to represent an analytics configuration.
     * 
     * @return The identifier used to represent an analytics configuration.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBucketAnalyticsConfigurationRequest)) {
            return false;
        }
        DeleteBucketAnalyticsConfigurationRequest other = (DeleteBucketAnalyticsConfigurationRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteBucketAnalyticsConfigurationRequest> {
        /**
         * The name of the bucket from which an analytics configuration is deleted.
         * 
         * @param bucket
         *        The name of the bucket from which an analytics configuration is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The identifier used to represent an analytics configuration.
         * 
         * @param id
         *        The identifier used to represent an analytics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBucketAnalyticsConfigurationRequest model) {
            bucket(model.bucket);
            id(model.id);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public DeleteBucketAnalyticsConfigurationRequest build() {
            return new DeleteBucketAnalyticsConfigurationRequest(this);
        }
    }
}
