/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteObjectResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteObjectResponse.Builder, DeleteObjectResponse> {
    private final Boolean deleteMarker;

    private final String versionId;

    private final String requestCharged;

    private DeleteObjectResponse(BuilderImpl builder) {
        this.deleteMarker = builder.deleteMarker;
        this.versionId = builder.versionId;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete
     * marker.
     * 
     * @return Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a
     *         delete marker.
     */
    public Boolean deleteMarker() {
        return deleteMarker;
    }

    /**
     * Returns the version ID of the delete marker created as a result of the DELETE operation.
     * 
     * @return Returns the version ID of the delete marker created as a result of the DELETE operation.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(requestCharged);
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestChargedString() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deleteMarker() == null) ? 0 : deleteMarker().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((requestChargedString() == null) ? 0 : requestChargedString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectResponse)) {
            return false;
        }
        DeleteObjectResponse other = (DeleteObjectResponse) obj;
        if (other.deleteMarker() == null ^ this.deleteMarker() == null) {
            return false;
        }
        if (other.deleteMarker() != null && !other.deleteMarker().equals(this.deleteMarker())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.requestChargedString() == null ^ this.requestChargedString() == null) {
            return false;
        }
        if (other.requestChargedString() != null && !other.requestChargedString().equals(this.requestChargedString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deleteMarker() != null) {
            sb.append("DeleteMarker: ").append(deleteMarker()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (requestChargedString() != null) {
            sb.append("RequestCharged: ").append(requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteMarker":
            return Optional.of(clazz.cast(deleteMarker()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "RequestCharged":
            return Optional.of(clazz.cast(requestChargedString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteObjectResponse> {
        /**
         * Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete
         * marker.
         * 
         * @param deleteMarker
         *        Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a
         *        delete marker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMarker(Boolean deleteMarker);

        /**
         * Returns the version ID of the delete marker created as a result of the DELETE operation.
         * 
         * @param versionId
         *        Returns the version ID of the delete marker created as a result of the DELETE operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteMarker;

        private String versionId;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectResponse model) {
            deleteMarker(model.deleteMarker);
            versionId(model.versionId);
            requestCharged(model.requestCharged);
        }

        public final Boolean getDeleteMarker() {
            return deleteMarker;
        }

        @Override
        public final Builder deleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
            return this;
        }

        public final void setDeleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public DeleteObjectResponse build() {
            return new DeleteObjectResponse(this);
        }
    }
}
