/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Destination implements ToCopyableBuilder<Destination.Builder, Destination> {
    private final String bucket;

    private final String storageClass;

    private Destination(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.storageClass = builder.storageClass;
    }

    /**
     * Amazon resource name (ARN) of the bucket where you want Amazon S3 to store replicas of the object identified by
     * the rule.
     * 
     * @return Amazon resource name (ARN) of the bucket where you want Amazon S3 to store replicas of the object
     *         identified by the rule.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((storageClassString() == null) ? 0 : storageClassString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.storageClassString() == null ^ this.storageClassString() == null) {
            return false;
        }
        if (other.storageClassString() != null && !other.storageClassString().equals(this.storageClassString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (storageClassString() != null) {
            sb.append("StorageClass: ").append(storageClassString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Destination> {
        /**
         * Amazon resource name (ARN) of the bucket where you want Amazon S3 to store replicas of the object identified
         * by the rule.
         * 
         * @param bucket
         *        Amazon resource name (ARN) of the bucket where you want Amazon S3 to store replicas of the object
         *        identified by the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            bucket(model.bucket);
            storageClass(model.storageClass);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }
    }
}
