/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * Bucket event for which to send notifications.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Event {
    S3_REDUCED_REDUNDANCY_LOST_OBJECT("s3:ReducedRedundancyLostObject"),

    S3_OBJECT_CREATED("s3:ObjectCreated:*"),

    S3_OBJECT_CREATED_PUT("s3:ObjectCreated:Put"),

    S3_OBJECT_CREATED_POST("s3:ObjectCreated:Post"),

    S3_OBJECT_CREATED_COPY("s3:ObjectCreated:Copy"),

    S3_OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD("s3:ObjectCreated:CompleteMultipartUpload"),

    S3_OBJECT_REMOVED("s3:ObjectRemoved:*"),

    S3_OBJECT_REMOVED_DELETE("s3:ObjectRemoved:Delete"),

    S3_OBJECT_REMOVED_DELETE_MARKER_CREATED("s3:ObjectRemoved:DeleteMarkerCreated"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Event corresponding to the value
     */
    public static Event fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Event.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Event}s
     */
    public static Set<Event> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
