/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketPolicyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBucketPolicyResponse.Builder, GetBucketPolicyResponse> {
    private final String policy;

    private GetBucketPolicyResponse(BuilderImpl builder) {
        this.policy = builder.policy;
    }

    /**
     * The bucket policy as a JSON document.
     * 
     * @return The bucket policy as a JSON document.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketPolicyResponse)) {
            return false;
        }
        GetBucketPolicyResponse other = (GetBucketPolicyResponse) obj;
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.of(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBucketPolicyResponse> {
        /**
         * The bucket policy as a JSON document.
         * 
         * @param policy
         *        The bucket policy as a JSON document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);
    }

    static final class BuilderImpl implements Builder {
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketPolicyResponse model) {
            policy(model.policy);
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public GetBucketPolicyResponse build() {
            return new GetBucketPolicyResponse(this);
        }
    }
}
