/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class HeadObjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<HeadObjectRequest.Builder, HeadObjectRequest> {
    private final String bucket;

    private final String ifMatch;

    private final Instant ifModifiedSince;

    private final String ifNoneMatch;

    private final Instant ifUnmodifiedSince;

    private final String key;

    private final String range;

    private final String versionId;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKey;

    private final String sseCustomerKeyMD5;

    private final String requestPayer;

    private final Integer partNumber;

    private HeadObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.key = builder.key;
        this.range = builder.range;
        this.versionId = builder.versionId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.partNumber = builder.partNumber;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
     * (precondition failed).
     * 
     * @return Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
     *         (precondition failed).
     */
    public String ifMatch() {
        return ifMatch;
    }

    /**
     * Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).
     * 
     * @return Return the object only if it has been modified since the specified time, otherwise return a 304 (not
     *         modified).
     */
    public Instant ifModifiedSince() {
        return ifModifiedSince;
    }

    /**
     * Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not
     * modified).
     * 
     * @return Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a
     *         304 (not modified).
     */
    public String ifNoneMatch() {
        return ifNoneMatch;
    }

    /**
     * Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition
     * failed).
     * 
     * @return Return the object only if it has not been modified since the specified time, otherwise return a 412
     *         (precondition failed).
     */
    public Instant ifUnmodifiedSince() {
        return ifUnmodifiedSince;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
     * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
     * 
     * @return Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
     *         http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
     */
    public String range() {
        return range;
    }

    /**
     * VersionId used to reference a specific version of the object.
     * 
     * @return VersionId used to reference a specific version of the object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
     * store the object and then it is discarded; Amazon does not store the encryption key. The key must be appropriate
     * for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm header.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
     *         used to store the object and then it is discarded; Amazon does not store the encryption key. The key must
     *         be appropriate for use with the algorithm specified in the
     *         x-amz-server-side​-encryption​-customer-algorithm header.
     */
    public String sseCustomerKey() {
        return sseCustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerString() {
        return requestPayer;
    }

    /**
     * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a
     * 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts
     * in this object.
     * 
     * @return Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively
     *         performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and
     *         the number of parts in this object.
     */
    public Integer partNumber() {
        return partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((ifMatch() == null) ? 0 : ifMatch().hashCode());
        hashCode = 31 * hashCode + ((ifModifiedSince() == null) ? 0 : ifModifiedSince().hashCode());
        hashCode = 31 * hashCode + ((ifNoneMatch() == null) ? 0 : ifNoneMatch().hashCode());
        hashCode = 31 * hashCode + ((ifUnmodifiedSince() == null) ? 0 : ifUnmodifiedSince().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((range() == null) ? 0 : range().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKey() == null) ? 0 : sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((requestPayerString() == null) ? 0 : requestPayerString().hashCode());
        hashCode = 31 * hashCode + ((partNumber() == null) ? 0 : partNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeadObjectRequest)) {
            return false;
        }
        HeadObjectRequest other = (HeadObjectRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        if (other.ifMatch() != null && !other.ifMatch().equals(this.ifMatch())) {
            return false;
        }
        if (other.ifModifiedSince() == null ^ this.ifModifiedSince() == null) {
            return false;
        }
        if (other.ifModifiedSince() != null && !other.ifModifiedSince().equals(this.ifModifiedSince())) {
            return false;
        }
        if (other.ifNoneMatch() == null ^ this.ifNoneMatch() == null) {
            return false;
        }
        if (other.ifNoneMatch() != null && !other.ifNoneMatch().equals(this.ifNoneMatch())) {
            return false;
        }
        if (other.ifUnmodifiedSince() == null ^ this.ifUnmodifiedSince() == null) {
            return false;
        }
        if (other.ifUnmodifiedSince() != null && !other.ifUnmodifiedSince().equals(this.ifUnmodifiedSince())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.range() == null ^ this.range() == null) {
            return false;
        }
        if (other.range() != null && !other.range().equals(this.range())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        if (other.requestPayerString() != null && !other.requestPayerString().equals(this.requestPayerString())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        if (ifModifiedSince() != null) {
            sb.append("IfModifiedSince: ").append(ifModifiedSince()).append(",");
        }
        if (ifNoneMatch() != null) {
            sb.append("IfNoneMatch: ").append(ifNoneMatch()).append(",");
        }
        if (ifUnmodifiedSince() != null) {
            sb.append("IfUnmodifiedSince: ").append(ifUnmodifiedSince()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (range() != null) {
            sb.append("Range: ").append(range()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(sseCustomerKey()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (requestPayerString() != null) {
            sb.append("RequestPayer: ").append(requestPayerString()).append(",");
        }
        if (partNumber() != null) {
            sb.append("PartNumber: ").append(partNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "IfMatch":
            return Optional.of(clazz.cast(ifMatch()));
        case "IfModifiedSince":
            return Optional.of(clazz.cast(ifModifiedSince()));
        case "IfNoneMatch":
            return Optional.of(clazz.cast(ifNoneMatch()));
        case "IfUnmodifiedSince":
            return Optional.of(clazz.cast(ifUnmodifiedSince()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Range":
            return Optional.of(clazz.cast(range()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "SSECustomerAlgorithm":
            return Optional.of(clazz.cast(sseCustomerAlgorithm()));
        case "SSECustomerKey":
            return Optional.of(clazz.cast(sseCustomerKey()));
        case "SSECustomerKeyMD5":
            return Optional.of(clazz.cast(sseCustomerKeyMD5()));
        case "RequestPayer":
            return Optional.of(clazz.cast(requestPayerString()));
        case "PartNumber":
            return Optional.of(clazz.cast(partNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HeadObjectRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
         * (precondition failed).
         * 
         * @param ifMatch
         *        Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a
         *        412 (precondition failed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * Return the object only if it has been modified since the specified time, otherwise return a 304 (not
         * modified).
         * 
         * @param ifModifiedSince
         *        Return the object only if it has been modified since the specified time, otherwise return a 304 (not
         *        modified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifModifiedSince(Instant ifModifiedSince);

        /**
         * Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304
         * (not modified).
         * 
         * @param ifNoneMatch
         *        Return the object only if its entity tag (ETag) is different from the one specified, otherwise return
         *        a 304 (not modified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifNoneMatch(String ifNoneMatch);

        /**
         * Return the object only if it has not been modified since the specified time, otherwise return a 412
         * (precondition failed).
         * 
         * @param ifUnmodifiedSince
         *        Return the object only if it has not been modified since the specified time, otherwise return a 412
         *        (precondition failed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifUnmodifiedSince(Instant ifUnmodifiedSince);

        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
         * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
         * 
         * @param range
         *        Downloads the specified range bytes of an object. For more information about the HTTP Range header, go
         *        to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(String range);

        /**
         * VersionId used to reference a specific version of the object.
         * 
         * @param versionId
         *        VersionId used to reference a specific version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * 
         * @param sseCustomerAlgorithm
         *        Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
         * store the object and then it is discarded; Amazon does not store the encryption key. The key must be
         * appropriate for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
         * header.
         * 
         * @param sseCustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
         *        used to store the object and then it is discarded; Amazon does not store the encryption key. The key
         *        must be appropriate for use with the algorithm specified in the
         *        x-amz-server-side​-encryption​-customer-algorithm header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKey(String sseCustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param sseCustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a
         * 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of
         * parts in this object.
         * 
         * @param partNumber
         *        Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively
         *        performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part
         *        and the number of parts in this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String ifMatch;

        private Instant ifModifiedSince;

        private String ifNoneMatch;

        private Instant ifUnmodifiedSince;

        private String key;

        private String range;

        private String versionId;

        private String sseCustomerAlgorithm;

        private String sseCustomerKey;

        private String sseCustomerKeyMD5;

        private String requestPayer;

        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(HeadObjectRequest model) {
            bucket(model.bucket);
            ifMatch(model.ifMatch);
            ifModifiedSince(model.ifModifiedSince);
            ifNoneMatch(model.ifNoneMatch);
            ifUnmodifiedSince(model.ifUnmodifiedSince);
            key(model.key);
            range(model.range);
            versionId(model.versionId);
            sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            sseCustomerKey(model.sseCustomerKey);
            sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            requestPayer(model.requestPayer);
            partNumber(model.partNumber);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public final Instant getIfModifiedSince() {
            return ifModifiedSince;
        }

        @Override
        public final Builder ifModifiedSince(Instant ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public final void setIfModifiedSince(Instant ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        public final String getIfNoneMatch() {
            return ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        public final Instant getIfUnmodifiedSince() {
            return ifUnmodifiedSince;
        }

        @Override
        public final Builder ifUnmodifiedSince(Instant ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public final void setIfUnmodifiedSince(Instant ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRange() {
            return range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public HeadObjectRequest build() {
            return new HeadObjectRequest(this);
        }
    }
}
