/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleRule implements ToCopyableBuilder<LifecycleRule.Builder, LifecycleRule> {
    private final LifecycleExpiration expiration;

    private final String id;

    private final String prefix;

    private final LifecycleRuleFilter filter;

    private final String status;

    private final List<Transition> transitions;

    private final List<NoncurrentVersionTransition> noncurrentVersionTransitions;

    private final NoncurrentVersionExpiration noncurrentVersionExpiration;

    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private LifecycleRule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.filter = builder.filter;
        this.status = builder.status;
        this.transitions = builder.transitions;
        this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    /**
     * Returns the value of the Expiration property for this object.
     * 
     * @return The value of the Expiration property for this object.
     */
    public LifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
     * 
     * @return Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public LifecycleRuleFilter filter() {
        return filter;
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(status);
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * Returns the value of the Transitions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Transitions property for this object.
     */
    public List<Transition> transitions() {
        return transitions;
    }

    /**
     * Returns the value of the NoncurrentVersionTransitions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the NoncurrentVersionTransitions property for this object.
     */
    public List<NoncurrentVersionTransition> noncurrentVersionTransitions() {
        return noncurrentVersionTransitions;
    }

    /**
     * Returns the value of the NoncurrentVersionExpiration property for this object.
     * 
     * @return The value of the NoncurrentVersionExpiration property for this object.
     */
    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return noncurrentVersionExpiration;
    }

    /**
     * Returns the value of the AbortIncompleteMultipartUpload property for this object.
     * 
     * @return The value of the AbortIncompleteMultipartUpload property for this object.
     */
    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((transitions() == null) ? 0 : transitions().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionTransitions() == null) ? 0 : noncurrentVersionTransitions().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionExpiration() == null) ? 0 : noncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + ((abortIncompleteMultipartUpload() == null) ? 0 : abortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRule)) {
            return false;
        }
        LifecycleRule other = (LifecycleRule) obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.transitions() == null ^ this.transitions() == null) {
            return false;
        }
        if (other.transitions() != null && !other.transitions().equals(this.transitions())) {
            return false;
        }
        if (other.noncurrentVersionTransitions() == null ^ this.noncurrentVersionTransitions() == null) {
            return false;
        }
        if (other.noncurrentVersionTransitions() != null
                && !other.noncurrentVersionTransitions().equals(this.noncurrentVersionTransitions())) {
            return false;
        }
        if (other.noncurrentVersionExpiration() == null ^ this.noncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.noncurrentVersionExpiration() != null
                && !other.noncurrentVersionExpiration().equals(this.noncurrentVersionExpiration())) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() == null ^ this.abortIncompleteMultipartUpload() == null) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() != null
                && !other.abortIncompleteMultipartUpload().equals(this.abortIncompleteMultipartUpload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (transitions() != null) {
            sb.append("Transitions: ").append(transitions()).append(",");
        }
        if (noncurrentVersionTransitions() != null) {
            sb.append("NoncurrentVersionTransitions: ").append(noncurrentVersionTransitions()).append(",");
        }
        if (noncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(noncurrentVersionExpiration()).append(",");
        }
        if (abortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(abortIncompleteMultipartUpload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expiration":
            return Optional.of(clazz.cast(expiration()));
        case "ID":
            return Optional.of(clazz.cast(id()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "Filter":
            return Optional.of(clazz.cast(filter()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "Transitions":
            return Optional.of(clazz.cast(transitions()));
        case "NoncurrentVersionTransitions":
            return Optional.of(clazz.cast(noncurrentVersionTransitions()));
        case "NoncurrentVersionExpiration":
            return Optional.of(clazz.cast(noncurrentVersionExpiration()));
        case "AbortIncompleteMultipartUpload":
            return Optional.of(clazz.cast(abortIncompleteMultipartUpload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleRule> {
        /**
         * Sets the value of the Expiration property for this object.
         *
         * @param expiration
         *        The new value for the Expiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(LifecycleExpiration expiration);

        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter instead.
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies. This is deprecated; use Filter
         *        instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(LifecycleRuleFilter filter);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(String status);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(ExpirationStatus status);

        /**
         * Sets the value of the Transitions property for this object.
         *
         * @param transitions
         *        The new value for the Transitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Collection<Transition> transitions);

        /**
         * Sets the value of the Transitions property for this object.
         *
         * @param transitions
         *        The new value for the Transitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Transition... transitions);

        /**
         * Sets the value of the NoncurrentVersionTransitions property for this object.
         *
         * @param noncurrentVersionTransitions
         *        The new value for the NoncurrentVersionTransitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions);

        /**
         * Sets the value of the NoncurrentVersionTransitions property for this object.
         *
         * @param noncurrentVersionTransitions
         *        The new value for the NoncurrentVersionTransitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransitions(NoncurrentVersionTransition... noncurrentVersionTransitions);

        /**
         * Sets the value of the NoncurrentVersionExpiration property for this object.
         *
         * @param noncurrentVersionExpiration
         *        The new value for the NoncurrentVersionExpiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration);

        /**
         * Sets the value of the AbortIncompleteMultipartUpload property for this object.
         *
         * @param abortIncompleteMultipartUpload
         *        The new value for the AbortIncompleteMultipartUpload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload);
    }

    static final class BuilderImpl implements Builder {
        private LifecycleExpiration expiration;

        private String id;

        private String prefix;

        private LifecycleRuleFilter filter;

        private String status;

        private List<Transition> transitions;

        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;

        private NoncurrentVersionExpiration noncurrentVersionExpiration;

        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRule model) {
            expiration(model.expiration);
            id(model.id);
            prefix(model.prefix);
            filter(model.filter);
            status(model.status);
            transitions(model.transitions);
            noncurrentVersionTransitions(model.noncurrentVersionTransitions);
            noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return expiration != null ? expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final LifecycleRuleFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(LifecycleRuleFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(LifecycleRuleFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<Transition.Builder> getTransitions() {
            return transitions != null ? transitions.stream().map(Transition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitions(Collection<Transition> transitions) {
            this.transitions = TransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Transition... transitions) {
            transitions(Arrays.asList(transitions));
            return this;
        }

        public final void setTransitions(Collection<Transition.BuilderImpl> transitions) {
            this.transitions = TransitionListCopier.copyFromBuilder(transitions);
        }

        public final Collection<NoncurrentVersionTransition.Builder> getNoncurrentVersionTransitions() {
            return noncurrentVersionTransitions != null ? noncurrentVersionTransitions.stream()
                    .map(NoncurrentVersionTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copy(noncurrentVersionTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(NoncurrentVersionTransition... noncurrentVersionTransitions) {
            noncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransitions));
            return this;
        }

        public final void setNoncurrentVersionTransitions(
                Collection<NoncurrentVersionTransition.BuilderImpl> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier
                    .copyFromBuilder(noncurrentVersionTransitions);
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return noncurrentVersionExpiration != null ? noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(
                AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build()
                    : null;
        }

        @Override
        public LifecycleRule build() {
            return new LifecycleRule(this);
        }
    }
}
